/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.mojang.nbt.CompoundTag;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import util.Mth;

public class Particle
extends Entity {
    protected int tex;
    protected float uo;
    protected float vo;
    protected int age = 0;
    protected int lifetime = 0;
    protected float size;
    protected float gravity;
    protected float rCol;
    protected float gCol;
    protected float bCol;
    public static double xOff;
    public static double yOff;
    public static double zOff;

    public Particle(Level level, double x, double y, double z, double xa, double ya, double za) {
        super(level);
        this.setSize(0.2f, 0.2f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(x, y, z);
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.xd = xa + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        this.yd = ya + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        this.zd = za + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        float speed = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
        float dd = Mth.sqrt(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd);
        this.xd = this.xd / (double)dd * (double)speed * (double)0.4f;
        this.yd = this.yd / (double)dd * (double)speed * (double)0.4f + (double)0.1f;
        this.zd = this.zd / (double)dd * (double)speed * (double)0.4f;
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
        this.size = (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.lifetime = (int)(4.0f / (this.random.nextFloat() * 0.9f + 0.1f));
        this.age = 0;
        this.makeStepSound = false;
    }

    public Particle setPower(float power) {
        this.xd *= (double)power;
        this.yd = (this.yd - (double)0.1f) * (double)power + (double)0.1f;
        this.zd *= (double)power;
        return this;
    }

    public Particle scale(float scale) {
        this.setSize(0.2f * scale, 0.2f * scale);
        this.size *= scale;
        return this;
    }

    @Override
    protected void defineSynchedData() {
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.yd -= 0.04 * (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
    }

    public void render(Tesselator t, float a, float xa, float ya, float za, float xa2, float za2) {
        float u0 = (float)(this.tex % 16) / 16.0f;
        float u1 = u0 + 0.0624375f;
        float v0 = (float)(this.tex / 16) / 16.0f;
        float v1 = v0 + 0.0624375f;
        float r = 0.1f * this.size;
        float x = (float)(this.xo + (this.x - this.xo) * (double)a - xOff);
        float y = (float)(this.yo + (this.y - this.yo) * (double)a - yOff);
        float z = (float)(this.zo + (this.z - this.zo) * (double)a - zOff);
        float br = this.getBrightness(a);
        t.color(this.rCol * br, this.gCol * br, this.bCol * br);
        t.vertexUV(x - xa * r - xa2 * r, y - ya * r, z - za * r - za2 * r, u1, v1);
        t.vertexUV(x - xa * r + xa2 * r, y + ya * r, z - za * r + za2 * r, u1, v0);
        t.vertexUV(x + xa * r + xa2 * r, y + ya * r, z + za * r + za2 * r, u0, v0);
        t.vertexUV(x + xa * r - xa2 * r, y - ya * r, z + za * r - za2 * r, u0, v1);
    }

    public int getParticleTexture() {
        return 0;
    }

    @Override
    public void addAdditonalSaveData(CompoundTag entityTag) {
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
    }
}

