/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.world.level.Level;
import util.Mth;

public class NoteParticle
extends Particle {
    float oSize;

    public NoteParticle(Level level, double x, double y, double z, double xa, double ya, double za) {
        this(level, x, y, z, xa, ya, za, 2.0f);
    }

    public NoteParticle(Level level, double x, double y, double z, double xa, double ya, double za, float scale) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= (double)0.01f;
        this.yd *= (double)0.01f;
        this.zd *= (double)0.01f;
        this.yd += 0.2;
        this.rCol = Mth.sin(((float)xa + 0.0f) * (float)Math.PI * 2.0f) * 0.65f + 0.35f;
        this.gCol = Mth.sin(((float)xa + 0.33333334f) * (float)Math.PI * 2.0f) * 0.65f + 0.35f;
        this.bCol = Mth.sin(((float)xa + 0.6666667f) * (float)Math.PI * 2.0f) * 0.65f + 0.35f;
        this.size *= 0.75f;
        this.size *= scale;
        this.oSize = this.size;
        this.lifetime = 6;
        this.noPhysics = false;
        this.tex = 64;
    }

    @Override
    public void render(Tesselator t, float a, float xa, float ya, float za, float xa2, float za2) {
        float l = ((float)this.age + a) / (float)this.lifetime * 32.0f;
        if (l < 0.0f) {
            l = 0.0f;
        }
        if (l > 1.0f) {
            l = 1.0f;
        }
        this.size = this.oSize * l;
        super.render(t, a, xa, ya, za, xa2, za2);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= (double)0.66f;
        this.yd *= (double)0.66f;
        this.zd *= (double)0.66f;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
    }
}

