/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.world.level.Level;

public class LavaParticle
extends Particle {
    private float oSize;

    public LavaParticle(Level level, double x, double y, double z) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= (double)0.8f;
        this.yd *= (double)0.8f;
        this.zd *= (double)0.8f;
        this.yd = this.random.nextFloat() * 0.4f + 0.05f;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.size *= this.random.nextFloat() * 2.0f + 0.2f;
        this.oSize = this.size;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.noPhysics = false;
        this.tex = 49;
    }

    @Override
    public float getBrightness(float a) {
        return 1.0f;
    }

    @Override
    public void render(Tesselator t, float a, float xa, float ya, float za, float xa2, float za2) {
        float s = ((float)this.age + a) / (float)this.lifetime;
        this.size = this.oSize * (1.0f - s * s);
        super.render(t, a, xa, ya, za, xa2, za2);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        float odds = (float)this.age / (float)this.lifetime;
        if (this.random.nextFloat() > odds) {
            this.level.addParticle("smoke", this.x, this.y, this.z, this.xd, this.yd, this.zd);
        }
        this.yd -= 0.03;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.999f;
        this.yd *= (double)0.999f;
        this.zd *= (double)0.999f;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
    }
}

