/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.world.level.Level;

public class FlameParticle
extends Particle {
    private float oSize;

    public FlameParticle(Level level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.xd = this.xd * (double)0.01f + xd;
        this.yd = this.yd * (double)0.01f + yd;
        this.zd = this.zd * (double)0.01f + zd;
        x += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        y += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        z += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        this.oSize = this.size;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.noPhysics = true;
        this.tex = 48;
    }

    @Override
    public void render(Tesselator t, float a, float xa, float ya, float za, float xa2, float za2) {
        float s = ((float)this.age + a) / (float)this.lifetime;
        this.size = this.oSize * (1.0f - s * s * 0.5f);
        super.render(t, a, xa, ya, za, xa2, za2);
    }

    @Override
    public float getBrightness(float a) {
        float l = ((float)this.age + a) / (float)this.lifetime;
        if (l < 0.0f) {
            l = 0.0f;
        }
        if (l > 1.0f) {
            l = 1.0f;
        }
        float br = super.getBrightness(a);
        return br * l + (1.0f - l);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.96f;
        this.yd *= (double)0.96f;
        this.zd *= (double)0.96f;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
    }
}

