/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.world.level.Level;

public class ExplodeParticle
extends Particle {
    public ExplodeParticle(Level level, double x, double y, double z, double xa, double ya, double za) {
        super(level, x, y, z, xa, ya, za);
        this.xd = xa + (double)((float)(Math.random() * 2.0 - 1.0) * 0.05f);
        this.yd = ya + (double)((float)(Math.random() * 2.0 - 1.0) * 0.05f);
        this.zd = za + (double)((float)(Math.random() * 2.0 - 1.0) * 0.05f);
        this.gCol = this.bCol = this.random.nextFloat() * 0.3f + 0.7f;
        this.rCol = this.bCol;
        this.size = this.random.nextFloat() * this.random.nextFloat() * 6.0f + 1.0f;
        this.lifetime = (int)(16.0 / ((double)this.random.nextFloat() * 0.8 + 0.2)) + 2;
    }

    @Override
    public void render(Tesselator t, float a, float xa, float ya, float za, float xa2, float za2) {
        super.render(t, a, xa, ya, za, xa2, za2);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.tex = 7 - this.age * 8 / this.lifetime;
        this.yd += 0.004;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.9f;
        this.yd *= (double)0.9f;
        this.zd *= (double)0.9f;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
    }
}

