/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.Particle;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import util.Mth;

public class BubbleParticle
extends Particle {
    public BubbleParticle(Level level, double x, double y, double z, double xa, double ya, double za) {
        super(level, x, y, z, xa, ya, za);
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.tex = 32;
        this.setSize(0.02f, 0.02f);
        this.size *= this.random.nextFloat() * 0.6f + 0.2f;
        this.xd = xa * (double)0.2f + (double)((float)(Math.random() * 2.0 - 1.0) * 0.02f);
        this.yd = ya * (double)0.2f + (double)((float)(Math.random() * 2.0 - 1.0) * 0.02f);
        this.zd = za * (double)0.2f + (double)((float)(Math.random() * 2.0 - 1.0) * 0.02f);
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd += 0.002;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.85f;
        this.yd *= (double)0.85f;
        this.zd *= (double)0.85f;
        if (this.level.getMaterial(Mth.floor(this.x), Mth.floor(this.y), Mth.floor(this.z)) != Material.water) {
            this.remove();
        }
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }
}

