/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;

public class BreakingItemParticle
extends Particle {
    public BreakingItemParticle(Level level, double x, double y, double z, Item item) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.tex = item.getIcon(null);
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.gravity = Tile.snow.gravity;
        this.size /= 2.0f;
    }

    @Override
    public int getParticleTexture() {
        return 2;
    }

    @Override
    public void render(Tesselator t, float a, float xa, float ya, float za, float xa2, float za2) {
        float u0 = ((float)(this.tex % 16) + this.uo / 4.0f) / 16.0f;
        float u1 = u0 + 0.015609375f;
        float v0 = ((float)(this.tex / 16) + this.vo / 4.0f) / 16.0f;
        float v1 = v0 + 0.015609375f;
        float r = 0.1f * this.size;
        float x = (float)(this.xo + (this.x - this.xo) * (double)a - xOff);
        float y = (float)(this.yo + (this.y - this.yo) * (double)a - yOff);
        float z = (float)(this.zo + (this.z - this.zo) * (double)a - zOff);
        float br = this.getBrightness(a);
        t.color(br * this.rCol, br * this.gCol, br * this.bCol);
        t.vertexUV(x - xa * r - xa2 * r, y - ya * r, z - za * r - za2 * r, u0, v1);
        t.vertexUV(x - xa * r + xa2 * r, y + ya * r, z - za * r + za2 * r, u0, v0);
        t.vertexUV(x + xa * r + xa2 * r, y + ya * r, z + za * r + za2 * r, u1, v0);
        t.vertexUV(x + xa * r - xa2 * r, y - ya * r, z + za * r - za2 * r, u1, v1);
    }
}

