/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.multiplayer.ClientConnection;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.packet.AnimatePacket;
import net.minecraft.network.packet.ChatPacket;
import net.minecraft.network.packet.ContainerClosePacket;
import net.minecraft.network.packet.MovePlayerPacket;
import net.minecraft.network.packet.PlayerActionPacket;
import net.minecraft.network.packet.PlayerCommandPacket;
import net.minecraft.network.packet.RespawnPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import util.Mth;

public class MultiplayerLocalPlayer
extends LocalPlayer {
    public ClientConnection connection;
    private int lastInventorySendTime = 0;
    private boolean flashOnSetHealth = false;
    private double xLast;
    private double yLast1;
    private double yLast2;
    private double zLast;
    private float yRotLast;
    private float xRotLast;
    private boolean lastOnGround = false;
    private boolean lastSneaked = false;
    private int noSendTime = 0;

    public MultiplayerLocalPlayer(Minecraft minecraft, Level level, User user, ClientConnection connection) {
        super(minecraft, level, user, 0);
        this.connection = connection;
    }

    @Override
    public boolean hurt(Entity source, int dmg) {
        return false;
    }

    @Override
    public void heal(int heal) {
    }

    @Override
    public void tick() {
        if (!this.level.hasChunkAt(Mth.floor(this.x), 64, Mth.floor(this.z))) {
            return;
        }
        super.tick();
        this.sendPosition();
    }

    @Override
    public void prepareForTick() {
    }

    public void sendPosition() {
        boolean rot;
        boolean sneaking;
        if (this.lastInventorySendTime++ == 20) {
            this.ensureHasSentInventory();
            this.lastInventorySendTime = 0;
        }
        if ((sneaking = this.isSneaking()) != this.lastSneaked) {
            if (sneaking) {
                this.connection.send(new PlayerCommandPacket(this, 1));
            } else {
                this.connection.send(new PlayerCommandPacket(this, 2));
            }
            this.lastSneaked = sneaking;
        }
        double xdd = this.x - this.xLast;
        double ydd1 = this.bb.y0 - this.yLast1;
        double ydd2 = this.y - this.yLast2;
        double zdd = this.z - this.zLast;
        double rydd = this.yRot - this.yRotLast;
        double rxdd = this.xRot - this.xRotLast;
        boolean move = ydd1 != 0.0 || ydd2 != 0.0 || xdd != 0.0 || zdd != 0.0;
        boolean bl = rot = rydd != 0.0 || rxdd != 0.0;
        if (this.riding != null) {
            if (rot) {
                this.connection.send(new MovePlayerPacket.Pos(this.xd, -999.0, -999.0, this.zd, this.onGround));
            } else {
                this.connection.send(new MovePlayerPacket.PosRot(this.xd, -999.0, -999.0, this.zd, this.yRot, this.xRot, this.onGround));
            }
            move = false;
        } else if (move && rot) {
            this.connection.send(new MovePlayerPacket.PosRot(this.x, this.bb.y0, this.y, this.z, this.yRot, this.xRot, this.onGround));
            this.noSendTime = 0;
        } else if (move) {
            this.connection.send(new MovePlayerPacket.Pos(this.x, this.bb.y0, this.y, this.z, this.onGround));
            this.noSendTime = 0;
        } else if (rot) {
            this.connection.send(new MovePlayerPacket.Rot(this.yRot, this.xRot, this.onGround));
            this.noSendTime = 0;
        } else {
            this.connection.send(new MovePlayerPacket(this.onGround));
            this.noSendTime = this.lastOnGround != this.onGround || this.noSendTime > 20 ? 0 : ++this.noSendTime;
        }
        this.lastOnGround = this.onGround;
        if (move) {
            this.xLast = this.x;
            this.yLast1 = this.bb.y0;
            this.yLast2 = this.y;
            this.zLast = this.z;
        }
        if (rot) {
            this.yRotLast = this.yRot;
            this.xRotLast = this.xRot;
        }
    }

    @Override
    public void drop() {
        this.connection.send(new PlayerActionPacket(4, 0, 0, 0, 0));
    }

    private void ensureHasSentInventory() {
    }

    @Override
    protected void reallyDrop(ItemEntity itemEntity) {
    }

    @Override
    public void chat(String message) {
        this.connection.send(new ChatPacket(message));
    }

    @Override
    public void swing() {
        super.swing();
        this.connection.send(new AnimatePacket(this, 1));
    }

    @Override
    public void respawn() {
        this.ensureHasSentInventory();
        this.connection.send(new RespawnPacket());
    }

    @Override
    protected void actuallyHurt(int dmg) {
        this.health -= dmg;
    }

    @Override
    public void closeContainer() {
        this.connection.send(new ContainerClosePacket(this.containerMenu.containerId));
        this.inventory.setCarried(null);
        super.closeContainer();
    }

    @Override
    public void hurtTo(int newHealth) {
        if (this.flashOnSetHealth) {
            super.hurtTo(newHealth);
        } else {
            this.health = newHealth;
            this.flashOnSetHealth = true;
        }
    }
}

