/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.Cube;
import net.minecraft.client.model.Model;

public class SquidModel
extends Model {
    Cube body;
    Cube[] tentacles = new Cube[8];

    public SquidModel() {
        int yoffs = -16;
        this.body = new Cube(0, 0);
        this.body.addBox(-6.0f, -8.0f, -6.0f, 12, 16, 12);
        this.body.y += (float)(24 + yoffs);
        int i = 0;
        while (i < this.tentacles.length) {
            this.tentacles[i] = new Cube(48, 0);
            double angle = (double)i * Math.PI * 2.0 / (double)this.tentacles.length;
            float xo = (float)Math.cos(angle) * 5.0f;
            float yo = (float)Math.sin(angle) * 5.0f;
            this.tentacles[i].addBox(-1.0f, 0.0f, -1.0f, 2, 18, 2);
            this.tentacles[i].x = xo;
            this.tentacles[i].z = yo;
            this.tentacles[i].y = 31 + yoffs;
            angle = (double)i * Math.PI * -2.0 / (double)this.tentacles.length + 1.5707963267948966;
            this.tentacles[i].yRot = (float)angle;
            ++i;
        }
    }

    @Override
    public void setupAnim(float time, float r, float bob, float yRot, float xRot, float scale) {
        int i = 0;
        while (i < this.tentacles.length) {
            this.tentacles[i].xRot = bob;
            ++i;
        }
    }

    @Override
    public void render(float time, float r, float bob, float yRot, float xRot, float scale) {
        this.setupAnim(time, r, bob, yRot, xRot, scale);
        this.body.render(scale);
        int i = 0;
        while (i < this.tentacles.length) {
            this.tentacles[i].render(scale);
            ++i;
        }
    }
}

