/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.Cube;
import net.minecraft.client.model.Model;
import util.Mth;

public class QuadrupedModel
extends Model {
    public Cube head = new Cube(0, 0);
    public Cube hair;
    public Cube body;
    public Cube leg0;
    public Cube leg1;
    public Cube leg2;
    public Cube leg3;

    public QuadrupedModel(int legSize, float g) {
        this.head.addBox(-4.0f, -4.0f, -8.0f, 8, 8, 8, g);
        this.head.setPos(0.0f, 18 - legSize, -6.0f);
        this.body = new Cube(28, 8);
        this.body.addBox(-5.0f, -10.0f, -7.0f, 10, 16, 8, g);
        this.body.setPos(0.0f, 17 - legSize, 2.0f);
        this.leg0 = new Cube(0, 16);
        this.leg0.addBox(-2.0f, 0.0f, -2.0f, 4, legSize, 4, g);
        this.leg0.setPos(-3.0f, 24 - legSize, 7.0f);
        this.leg1 = new Cube(0, 16);
        this.leg1.addBox(-2.0f, 0.0f, -2.0f, 4, legSize, 4, g);
        this.leg1.setPos(3.0f, 24 - legSize, 7.0f);
        this.leg2 = new Cube(0, 16);
        this.leg2.addBox(-2.0f, 0.0f, -2.0f, 4, legSize, 4, g);
        this.leg2.setPos(-3.0f, 24 - legSize, -5.0f);
        this.leg3 = new Cube(0, 16);
        this.leg3.addBox(-2.0f, 0.0f, -2.0f, 4, legSize, 4, g);
        this.leg3.setPos(3.0f, 24 - legSize, -5.0f);
    }

    @Override
    public void render(float time, float r, float bob, float yRot, float xRot, float scale) {
        this.setupAnim(time, r, bob, yRot, xRot, scale);
        this.head.render(scale);
        this.body.render(scale);
        this.leg0.render(scale);
        this.leg1.render(scale);
        this.leg2.render(scale);
        this.leg3.render(scale);
    }

    @Override
    public void setupAnim(float time, float r, float bob, float yRot, float xRot, float scale) {
        this.head.xRot = -(xRot / 57.295776f);
        this.head.yRot = yRot / 57.295776f;
        this.body.xRot = 1.5707964f;
        this.leg0.xRot = Mth.cos(time * 0.6662f) * 1.4f * r;
        this.leg1.xRot = Mth.cos(time * 0.6662f + (float)Math.PI) * 1.4f * r;
        this.leg2.xRot = Mth.cos(time * 0.6662f + (float)Math.PI) * 1.4f * r;
        this.leg3.xRot = Mth.cos(time * 0.6662f) * 1.4f * r;
    }

    public void render(QuadrupedModel model, float scale) {
        this.head.yRot = model.head.yRot;
        this.head.xRot = model.head.xRot;
        this.head.y = model.head.y;
        this.head.x = model.head.x;
        this.body.yRot = model.body.yRot;
        this.body.xRot = model.body.xRot;
        this.leg0.xRot = model.leg0.xRot;
        this.leg1.xRot = model.leg1.xRot;
        this.leg2.xRot = model.leg2.xRot;
        this.leg3.xRot = model.leg3.xRot;
        this.head.render(scale);
        this.body.render(scale);
        this.leg0.render(scale);
        this.leg1.render(scale);
        this.leg2.render(scale);
        this.leg3.render(scale);
    }
}

