/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.Cube;
import net.minecraft.client.model.Model;
import util.Mth;

public class HumanoidModel
extends Model {
    public Cube head;
    public Cube hair;
    public Cube body;
    public Cube arm0;
    public Cube arm1;
    public Cube leg0;
    public Cube leg1;
    public Cube ear;
    public Cube cloak = new Cube(0, 0);
    public boolean holdingLeftHand = false;
    public boolean holdingRightHand = false;
    public boolean sneaking = false;

    public HumanoidModel() {
        this(0.0f);
    }

    public HumanoidModel(float g) {
        this(g, 0.0f);
    }

    public HumanoidModel(float g, float yOffset) {
        this.cloak.addBox(-5.0f, 0.0f, -1.0f, 10, 16, 1, g);
        this.ear = new Cube(24, 0);
        this.ear.addBox(-3.0f, -6.0f, -1.0f, 6, 6, 1, g);
        this.head = new Cube(0, 0);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, g);
        this.head.setPos(0.0f, 0.0f + yOffset, 0.0f);
        this.hair = new Cube(32, 0);
        this.hair.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, g + 0.5f);
        this.hair.setPos(0.0f, 0.0f + yOffset, 0.0f);
        this.body = new Cube(16, 16);
        this.body.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4, g);
        this.body.setPos(0.0f, 0.0f + yOffset, 0.0f);
        this.arm0 = new Cube(40, 16);
        this.arm0.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4, g);
        this.arm0.setPos(-5.0f, 2.0f + yOffset, 0.0f);
        this.arm1 = new Cube(40, 16);
        this.arm1.mirror = true;
        this.arm1.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, g);
        this.arm1.setPos(5.0f, 2.0f + yOffset, 0.0f);
        this.leg0 = new Cube(0, 16);
        this.leg0.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, g);
        this.leg0.setPos(-2.0f, 12.0f + yOffset, 0.0f);
        this.leg1 = new Cube(0, 16);
        this.leg1.mirror = true;
        this.leg1.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, g);
        this.leg1.setPos(2.0f, 12.0f + yOffset, 0.0f);
    }

    @Override
    public void render(float time, float r, float bob, float yRot, float xRot, float scale) {
        this.setupAnim(time, r, bob, yRot, xRot, scale);
        this.head.render(scale);
        this.body.render(scale);
        this.arm0.render(scale);
        this.arm1.render(scale);
        this.leg0.render(scale);
        this.leg1.render(scale);
        this.hair.render(scale);
    }

    @Override
    public void setupAnim(float time, float r, float bob, float yRot, float xRot, float scale) {
        this.head.yRot = yRot / 57.295776f;
        this.head.xRot = xRot / 57.295776f;
        this.hair.yRot = this.head.yRot;
        this.hair.xRot = this.head.xRot;
        this.arm0.xRot = Mth.cos(time * 0.6662f + (float)Math.PI) * 2.0f * r * 0.5f;
        this.arm1.xRot = Mth.cos(time * 0.6662f) * 2.0f * r * 0.5f;
        this.arm0.zRot = 0.0f;
        this.arm1.zRot = 0.0f;
        this.leg0.xRot = Mth.cos(time * 0.6662f) * 1.4f * r;
        this.leg1.xRot = Mth.cos(time * 0.6662f + (float)Math.PI) * 1.4f * r;
        this.leg0.yRot = 0.0f;
        this.leg1.yRot = 0.0f;
        if (this.riding) {
            this.arm0.xRot += -0.62831855f;
            this.arm1.xRot += -0.62831855f;
            this.leg0.xRot = -1.2566371f;
            this.leg1.xRot = -1.2566371f;
            this.leg0.yRot = 0.31415927f;
            this.leg1.yRot = -0.31415927f;
        }
        if (this.holdingLeftHand) {
            this.arm1.xRot = this.arm1.xRot * 0.5f - 0.31415927f;
        }
        if (this.holdingRightHand) {
            this.arm0.xRot = this.arm0.xRot * 0.5f - 0.31415927f;
        }
        this.arm0.yRot = 0.0f;
        this.arm1.yRot = 0.0f;
        if (this.attackTime > -9990.0f) {
            float swing = this.attackTime;
            this.body.yRot = Mth.sin(Mth.sqrt(swing) * (float)Math.PI * 2.0f) * 0.2f;
            this.arm0.z = Mth.sin(this.body.yRot) * 5.0f;
            this.arm0.x = -Mth.cos(this.body.yRot) * 5.0f;
            this.arm1.z = -Mth.sin(this.body.yRot) * 5.0f;
            this.arm1.x = Mth.cos(this.body.yRot) * 5.0f;
            this.arm0.yRot += this.body.yRot;
            this.arm1.yRot += this.body.yRot;
            this.arm1.xRot += this.body.yRot;
            swing = 1.0f - this.attackTime;
            swing *= swing;
            swing *= swing;
            swing = 1.0f - swing;
            float aa = Mth.sin(swing * (float)Math.PI);
            float bb = Mth.sin(this.attackTime * (float)Math.PI) * -(this.head.xRot - 0.7f) * 0.75f;
            this.arm0.xRot = (float)((double)this.arm0.xRot - ((double)aa * 1.2 + (double)bb));
            this.arm0.yRot += this.body.yRot * 2.0f;
            this.arm0.zRot = Mth.sin(this.attackTime * (float)Math.PI) * -0.4f;
        }
        if (this.sneaking) {
            this.body.xRot = 0.5f;
            this.leg0.xRot -= 0.0f;
            this.leg1.xRot -= 0.0f;
            this.arm0.xRot += 0.4f;
            this.arm1.xRot += 0.4f;
            this.leg0.z = 4.0f;
            this.leg1.z = 4.0f;
            this.leg0.y = 9.0f;
            this.leg1.y = 9.0f;
            this.head.y = 1.0f;
        } else {
            this.body.xRot = 0.0f;
            this.leg0.z = 0.0f;
            this.leg1.z = 0.0f;
            this.leg0.y = 12.0f;
            this.leg1.y = 12.0f;
            this.head.y = 0.0f;
        }
        this.arm0.zRot += Mth.cos(bob * 0.09f) * 0.05f + 0.05f;
        this.arm1.zRot -= Mth.cos(bob * 0.09f) * 0.05f + 0.05f;
        this.arm0.xRot += Mth.sin(bob * 0.067f) * 0.05f;
        this.arm1.xRot -= Mth.sin(bob * 0.067f) * 0.05f;
    }

    public void renderHair(float scale) {
        this.hair.yRot = this.head.yRot;
        this.hair.xRot = this.head.xRot;
        this.hair.render(scale);
    }

    public void renderEars(float scale) {
        this.ear.yRot = this.head.yRot;
        this.ear.xRot = this.head.xRot;
        this.ear.x = 0.0f;
        this.ear.y = 0.0f;
        this.ear.render(scale);
    }

    public void renderCloak(float scale) {
        this.cloak.render(scale);
    }

    public void render(HumanoidModel model, float scale) {
        this.head.yRot = model.head.yRot;
        this.head.y = model.head.y;
        this.head.xRot = model.head.xRot;
        this.hair.yRot = this.head.yRot;
        this.hair.xRot = this.head.xRot;
        this.arm0.xRot = model.arm0.xRot;
        this.arm0.zRot = model.arm0.zRot;
        this.arm1.xRot = model.arm1.xRot;
        this.arm1.zRot = model.arm1.zRot;
        this.leg0.xRot = model.leg0.xRot;
        this.leg1.xRot = model.leg1.xRot;
        this.head.render(scale);
        this.body.render(scale);
        this.arm0.render(scale);
        this.arm1.render(scale);
        this.leg0.render(scale);
        this.leg1.render(scale);
        this.hair.render(scale);
    }
}

