/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import java.util.Random;
import net.minecraft.client.model.Cube;
import net.minecraft.client.model.Model;
import util.Mth;

public class GhastModel
extends Model {
    Cube body;
    Cube[] tentacles = new Cube[9];

    public GhastModel() {
        int yoffs = -16;
        this.body = new Cube(0, 0);
        this.body.addBox(-8.0f, -8.0f, -8.0f, 16, 16, 16);
        this.body.y += (float)(24 + yoffs);
        Random random = new Random(1660L);
        int i = 0;
        while (i < this.tentacles.length) {
            this.tentacles[i] = new Cube(0, 0);
            float xo = (((float)(i % 3) - (float)(i / 3 % 2) * 0.5f + 0.25f) / 2.0f * 2.0f - 1.0f) * 5.0f;
            float yo = ((float)(i / 3) / 2.0f * 2.0f - 1.0f) * 5.0f;
            int len = random.nextInt(7) + 8;
            this.tentacles[i].addBox(-1.0f, 0.0f, -1.0f, 2, len, 2);
            this.tentacles[i].x = xo;
            this.tentacles[i].z = yo;
            this.tentacles[i].y = 31 + yoffs;
            ++i;
        }
    }

    @Override
    public void setupAnim(float time, float r, float bob, float yRot, float xRot, float scale) {
        int i = 0;
        while (i < this.tentacles.length) {
            this.tentacles[i].xRot = 0.2f * Mth.sin(bob * 0.3f + (float)i) + 0.4f;
            ++i;
        }
    }

    @Override
    public void render(float time, float r, float bob, float yRot, float xRot, float scale) {
        this.setupAnim(time, r, bob, yRot, xRot, scale);
        this.body.render(scale);
        int i = 0;
        while (i < this.tentacles.length) {
            this.tentacles[i].render(scale);
            ++i;
        }
    }
}

