/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JFrame;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.Dimension;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class Map
extends JComponent {
    private static final long serialVersionUID = 1L;
    private BufferedImage img;
    private int[] pixels;
    private int w;
    private int h;
    private int xMouse;
    private int yMouse;
    public int xCam;
    public int yCam;
    Level level = new Level("TEST", new Dimension(), new Random().nextLong());
    String hovered = null;
    public PerlinSimplexNoise scaleNoise = new PerlinSimplexNoise(new Random(), 10);
    public PerlinSimplexNoise depthNoise = new PerlinSimplexNoise(new Random(), 10);
    double[] pnr;
    double[] ar;
    double[] br;
    double[] sr;
    double[] dr;
    double[] fi;
    double[] fis;

    public Map(int w, int h) {
        this.w = w;
        this.h = h;
        this.img = new BufferedImage(w, h, 1);
        this.setPreferredSize(new java.awt.Dimension(w * 2, h * 2));
        this.setMinimumSize(new java.awt.Dimension(w * 2, h * 2));
        this.setMaximumSize(new java.awt.Dimension(w * 2, h * 2));
        this.pixels = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
                Map.this.xMouse = me.getX() / 2;
                Map.this.yMouse = me.getY() / 2;
            }

            @Override
            public void mouseReleased(MouseEvent me) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent me) {
                Map.this.xCam += me.getX() / 2 - Map.this.xMouse;
                Map.this.yCam += me.getY() / 2 - Map.this.yMouse;
                Map.this.xMouse = me.getX() / 2;
                Map.this.yMouse = me.getY() / 2;
            }

            @Override
            public void mouseMoved(MouseEvent me) {
                Map.this.xMouse = me.getX() / 2;
                Map.this.yMouse = me.getY() / 2;
            }
        });
    }

    private void buildMapImage(int x, int z, double ss) {
        Biome.recalc();
        Biome[] biomes = this.level.getBiomeSource().getBiomeBlock(x, z, this.w, this.h);
        double[] temperatures = this.level.getBiomeSource().temperatures;
        double[] downfalls = this.level.getBiomeSource().downfalls;
        this.sr = this.scaleNoise.getRegion(this.sr, z, x, this.w, this.h, 1.0, 1.0, 0.45454545454545453);
        this.dr = this.depthNoise.getRegion(this.dr, z, x, this.w, this.h, 1.0, 1.0, 0.49751243781094534, 0.5);
        int i = 0;
        while (i < this.pixels.length) {
            int xp = i / this.w;
            int zp = i % this.w;
            int pp = xp + zp * this.w;
            double scale = (this.sr[pp] + 256.0) / 512.0;
            if (scale > 1.0) {
                scale = 1.0;
            }
            double temperature = temperatures[i];
            double downfall = downfalls[i] * temperature;
            double dd = 1.0 - downfall;
            dd *= dd;
            dd *= dd;
            dd = 1.0 - dd;
            scale *= dd;
            double depth = this.dr[pp] / 2000.0;
            if (depth < 0.0) {
                depth = -depth - 0.1;
            }
            if ((depth = (depth - 0.01) * 100.0) < 0.0) {
                if ((depth /= 2.0) < -1.0) {
                    depth = -1.0;
                }
                depth /= 1.4;
                scale = 0.0;
            } else {
                if ((depth /= 6.0) > 1.0) {
                    depth = 1.0;
                }
                depth *= dd * 0.8 + 0.2;
            }
            scale += 0.5;
            depth = depth * 8.0 / 16.0;
            double yCenter = 4.0 + depth * 4.0;
            Biome biome = biomes[xp * this.h + zp];
            if (xp == this.xMouse && zp == this.yMouse) {
                double temp = temperatures[xp * this.h + zp];
                double down = downfalls[xp * this.h + zp];
                this.hovered = String.valueOf(biome.name) + " (" + (int)(temp * 100.0) + "/" + (int)(down * 100.0) + ")";
            }
            if (!(yCenter < 4.0)) {
                int br;
                int r = br = (int)((yCenter - 4.0) * 64.0);
                int g = br;
                int b = br;
                this.pixels[pp] = r << 16 | g << 8 | b;
            }
            ++i;
        }
    }

    @Override
    public void paint(Graphics g) {
        double s = 0.03125;
        this.buildMapImage(-this.xCam, -this.yCam, s * 4.0 * 128.0);
        g.drawImage(this.img, 0, 0, this.w * 2, this.h * 2, 0, 0, this.w, this.h, null);
        if (this.hovered != null) {
            g.setColor(Color.black);
            Rectangle r = g.getFontMetrics().getStringBounds(this.hovered, null).getBounds();
            g.fillRect(this.xMouse * 2 + r.x - 2, this.yMouse * 2 + r.y, r.width + 4, r.height);
            g.setColor(Color.white);
            g.drawString(this.hovered, this.xMouse * 2, this.yMouse * 2);
        }
        this.repaint();
    }

    public static void main(String[] args) {
        Map mapComponent = new Map(480, 480);
        JFrame frame = new JFrame("Map test");
        frame.add(mapComponent);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

