/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.inventory;

import net.minecraft.SharedConstants;
import net.minecraft.client.gui.Button;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.renderer.tileentity.TileEntityRenderDispatcher;
import net.minecraft.network.packet.SignUpdatePacket;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.SignTileEntity;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class TextEditScreen
extends Screen {
    protected String title = "Edit sign message:";
    private SignTileEntity sign;
    private int frame;
    private int line = 0;
    private static final String allowedChars = SharedConstants.acceptableLetters;

    public TextEditScreen(SignTileEntity sign) {
        this.sign = sign;
    }

    @Override
    public void init() {
        this.buttons.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttons.add(new Button(0, this.width / 2 - 100, this.height / 4 + 120, "Done"));
    }

    @Override
    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.minecraft.level.isOnline) {
            this.minecraft.getConnection().send(new SignUpdatePacket(this.sign.x, this.sign.y, this.sign.z, this.sign.messages));
        }
    }

    @Override
    public void tick() {
        ++this.frame;
    }

    @Override
    protected void buttonClicked(Button button) {
        if (!button.active) {
            return;
        }
        if (button.id == 0) {
            this.sign.setChanged();
            this.minecraft.setScreen(null);
        }
    }

    @Override
    protected void keyPressed(char ch, int eventKey) {
        if (eventKey == 200) {
            this.line = this.line - 1 & 3;
        }
        if (eventKey == 208 || eventKey == 28) {
            this.line = this.line + 1 & 3;
        }
        if (eventKey == 14 && this.sign.messages[this.line].length() > 0) {
            this.sign.messages[this.line] = this.sign.messages[this.line].substring(0, this.sign.messages[this.line].length() - 1);
        }
        if (allowedChars.indexOf(ch) >= 0 && this.sign.messages[this.line].length() < 15) {
            int n = this.line;
            this.sign.messages[n] = String.valueOf(this.sign.messages[n]) + ch;
        }
    }

    @Override
    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.title, this.width / 2, 40, 0xFFFFFF);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.width / 2), (float)(this.height / 2), (float)50.0f);
        float ss = 93.75f;
        GL11.glScalef((float)(-ss), (float)(-ss), (float)(-ss));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Tile tile = this.sign.getTile();
        if (tile == Tile.sign) {
            float rot = (float)(this.sign.getData() * 360) / 16.0f;
            GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
        } else {
            int face = this.sign.getData();
            float rot = 0.0f;
            if (face == 2) {
                rot = 180.0f;
            }
            if (face == 4) {
                rot = 90.0f;
            }
            if (face == 5) {
                rot = -90.0f;
            }
            GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
        }
        if (this.frame / 6 % 2 == 0) {
            this.sign.selectedLine = this.line;
        }
        TileEntityRenderDispatcher.instance.render(this.sign, -0.5, -0.75, -0.5, 0.0f);
        this.sign.selectedLine = -1;
        GL11.glPopMatrix();
        super.render(xm, ym, a);
    }
}

