/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.inventory;

import net.minecraft.client.Lighting;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.locale.Language;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemInstance;
import org.lwjgl.opengl.GL11;

public abstract class AbstractContainerScreen
extends Screen {
    private static ItemRenderer itemRenderer = new ItemRenderer();
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    public AbstractContainerMenu menu;

    public AbstractContainerScreen(AbstractContainerMenu abstractContainerMenu) {
        this.menu = abstractContainerMenu;
    }

    public void init() {
        super.init();
        this.minecraft.player.containerMenu = this.menu;
    }

    public void render(int n, int n2, float f) {
        int n3;
        int n4;
        Object object;
        this.renderBackground();
        int n5 = (this.width - this.imageWidth) / 2;
        int n6 = (this.height - this.imageHeight) / 2;
        this.renderBg(f);
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Lighting.turnOn();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)n5, (float)n6, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        Slot slot = null;
        for (int i = 0; i < this.menu.slots.size(); ++i) {
            object = this.menu.slots.get(i);
            this.renderSlot((Slot)object);
            if (!this.isHovering((Slot)object, n, n2)) continue;
            slot = object;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            n4 = ((Slot)object).x;
            n3 = ((Slot)object).y;
            this.fillGradient(n4, n3, n4 + 16, n3 + 16, -2130706433, -2130706433);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        Inventory inventory = this.minecraft.player.inventory;
        if (inventory.getCarried() != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            itemRenderer.renderGuiItem(this.font, this.minecraft.textures, inventory.getCarried(), n - n5 - 8, n2 - n6 - 8);
            itemRenderer.renderGuiItemDecorations(this.font, this.minecraft.textures, inventory.getCarried(), n - n5 - 8, n2 - n6 - 8);
        }
        GL11.glDisable((int)32826);
        Lighting.turnOff();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.renderLabels();
        if (inventory.getCarried() == null && slot != null && slot.hasItem() && ((String)(object = ("" + Language.getInstance().getElementName(slot.getItem().getDescriptionId())).trim())).length() > 0) {
            n4 = n - n5 + 12;
            n3 = n2 - n6 - 12;
            int n7 = this.font.width((String)object);
            this.fillGradient(n4 - 3, n3 - 3, n4 + n7 + 3, n3 + 8 + 3, -1073741824, -1073741824);
            this.font.drawShadow((String)object, n4, n3, -1);
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    protected void renderLabels() {
    }

    protected abstract void renderBg(float var1);

    private void renderSlot(Slot slot) {
        int n;
        int n2 = slot.x;
        int n3 = slot.y;
        ItemInstance itemInstance = slot.getItem();
        if (itemInstance == null && (n = slot.getNoItemIcon()) >= 0) {
            GL11.glDisable((int)2896);
            this.minecraft.textures.bind(this.minecraft.textures.loadTexture("/gui/items.png"));
            this.blit(n2, n3, n % 16 * 16, n / 16 * 16, 16, 16);
            GL11.glEnable((int)2896);
            return;
        }
        itemRenderer.renderGuiItem(this.font, this.minecraft.textures, itemInstance, n2, n3);
        itemRenderer.renderGuiItemDecorations(this.font, this.minecraft.textures, itemInstance, n2, n3);
    }

    private Slot findSlot(int n, int n2) {
        for (int i = 0; i < this.menu.slots.size(); ++i) {
            Slot slot = this.menu.slots.get(i);
            if (!this.isHovering(slot, n, n2)) continue;
            return slot;
        }
        return null;
    }

    private boolean isHovering(Slot slot, int n, int n2) {
        int n3 = (this.width - this.imageWidth) / 2;
        int n4 = (this.height - this.imageHeight) / 2;
        return (n -= n3) >= slot.x - 1 && n < slot.x + 16 + 1 && (n2 -= n4) >= slot.y - 1 && n2 < slot.y + 16 + 1;
    }

    protected void mouseClicked(int n, int n2, int n3) {
        if (n3 == 0 || n3 == 1) {
            Slot slot = this.findSlot(n, n2);
            int n4 = (this.width - this.imageWidth) / 2;
            int n5 = (this.height - this.imageHeight) / 2;
            boolean bl = n < n4 || n2 < n5 || n >= n4 + this.imageWidth || n2 >= n5 + this.imageHeight;
            int n6 = -1;
            if (slot != null) {
                n6 = slot.index;
            }
            if (bl) {
                n6 = -999;
            }
            if (n6 != -1) {
                this.minecraft.gameMode.handleInventoryMouseClick(this.menu.containerId, n6, n3, this.minecraft.player);
            }
        }
    }

    protected void mouseReleased(int n, int n2, int n3) {
        if (n3 == 0) {
            // empty if block
        }
    }

    protected void keyPressed(char c, int n) {
    }

    public void removed() {
        if (this.minecraft.player == null) {
            return;
        }
        this.minecraft.gameMode.handleCloseInventory(this.menu.containerId, this.minecraft.player);
    }

    public void slotsChanged(Container container) {
    }

    public boolean isPauseScreen() {
        return false;
    }
}

