/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Button;
import org.lwjgl.opengl.GL11;

public class SlideButton
extends Button {
    public float value = 1.0f;
    public boolean sliding = false;
    private Options.Option option = null;

    public SlideButton(int id, int x, int y, Options.Option option, String msg, float value) {
        super(id, x, y, 150, 20, msg);
        this.option = option;
        this.value = value;
    }

    @Override
    protected int getYImage(boolean hovered) {
        return 0;
    }

    @Override
    protected void renderBg(Minecraft minecraft, int xm, int ym) {
        if (!this.visible) {
            return;
        }
        if (this.sliding) {
            this.value = (float)(xm - (this.x + 4)) / (float)(this.w - 8);
            if (this.value < 0.0f) {
                this.value = 0.0f;
            }
            if (this.value > 1.0f) {
                this.value = 1.0f;
            }
            minecraft.options.set(this.option, this.value);
            this.msg = minecraft.options.getMessage(this.option);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(this.x + (int)(this.value * (float)(this.w - 8)), this.y, 0, 66, 4, 20);
        this.blit(this.x + (int)(this.value * (float)(this.w - 8)) + 4, this.y, 196, 66, 4, 20);
    }

    @Override
    public boolean clicked(Minecraft minecraft, int mx, int my) {
        if (super.clicked(minecraft, mx, my)) {
            this.value = (float)(mx - (this.x + 4)) / (float)(this.w - 8);
            if (this.value < 0.0f) {
                this.value = 0.0f;
            }
            if (this.value > 1.0f) {
                this.value = 1.0f;
            }
            minecraft.options.set(this.option, this.value);
            this.msg = minecraft.options.getMessage(this.option);
            this.sliding = true;
            return true;
        }
        return false;
    }

    @Override
    public void released(int mx, int my) {
        this.sliding = false;
    }
}

