/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.mojang.nbt.CompoundTag;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gamemode.SurvivalMode;
import net.minecraft.client.gui.Button;
import net.minecraft.client.gui.DeleteWorldScreen;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.locale.Language;
import net.minecraft.world.level.Level;

public class SelectWorldScreen
extends Screen {
    protected Screen lastScreen;
    protected String title = "Select world";
    private boolean done = false;

    public SelectWorldScreen(Screen screen) {
        this.lastScreen = screen;
    }

    public void init() {
        Language language = Language.getInstance();
        this.title = language.getElement("selectWorld.title");
        String string = language.getElement("selectWorld.empty");
        String string2 = language.getElement("selectWorld.world");
        File file = Minecraft.getWorkingDirectory();
        for (int i = 0; i < 5; ++i) {
            CompoundTag compoundTag = Level.getDataTagFor(file, "World" + (i + 1));
            if (compoundTag == null) {
                this.buttons.add(new Button(i, this.width / 2 - 100, this.height / 6 + 24 * i, "- " + string + " -"));
                continue;
            }
            String string3 = string2 + " " + (i + 1);
            long l = compoundTag.getLong("SizeOnDisk");
            string3 = string3 + " (" + (float)(l / 1024L * 100L / 1024L) / 100.0f + " MB)";
            this.buttons.add(new Button(i, this.width / 2 - 100, this.height / 6 + 24 * i, string3));
        }
        this.postInit();
    }

    protected String getWorldName(int n) {
        File file = Minecraft.getWorkingDirectory();
        return Level.getDataTagFor(file, "World" + n) != null ? "World" + n : null;
    }

    public void postInit() {
        Language language = Language.getInstance();
        this.buttons.add(new Button(5, this.width / 2 - 100, this.height / 6 + 120 + 12, language.getElement("selectWorld.delete")));
        this.buttons.add(new Button(6, this.width / 2 - 100, this.height / 6 + 168, language.getElement("gui.cancel")));
    }

    protected void buttonClicked(Button button) {
        if (!button.active) {
            return;
        }
        if (button.id < 5) {
            this.worldSelected(button.id + 1);
        } else if (button.id == 5) {
            this.minecraft.setScreen(new DeleteWorldScreen(this));
        } else if (button.id == 6) {
            this.minecraft.setScreen(this.lastScreen);
        }
    }

    public void worldSelected(int n) {
        this.minecraft.setScreen(null);
        if (this.done) {
            return;
        }
        this.done = true;
        this.minecraft.gameMode = new SurvivalMode(this.minecraft);
        this.minecraft.selectLevel("World" + n);
        this.minecraft.setScreen(null);
    }

    public void render(int n, int n2, float f) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        super.render(n, n2, f);
    }
}

