/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Button;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.Tesselator;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class Screen
extends GuiComponent {
    protected Minecraft minecraft;
    public int width;
    public int height;
    protected List<Button> buttons = new ArrayList<Button>();
    public boolean passEvents = false;
    protected Font font;
    private Button clickedButton = null;

    public void render(int xm, int ym, float a) {
        int i = 0;
        while (i < this.buttons.size()) {
            Button button = this.buttons.get(i);
            button.render(this.minecraft, xm, ym);
            ++i;
        }
    }

    protected void keyPressed(char eventCharacter, int eventKey) {
        if (eventKey == 1) {
            this.minecraft.setScreen(null);
            this.minecraft.grabMouse();
        }
    }

    public static String getClipboard() {
        try {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                return text;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void setClipboard(String str) {
        try {
            StringSelection ss = new StringSelection(str);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void mouseClicked(int x, int y, int buttonNum) {
        if (buttonNum == 0) {
            int i = 0;
            while (i < this.buttons.size()) {
                Button button = this.buttons.get(i);
                if (button.clicked(this.minecraft, x, y)) {
                    this.clickedButton = button;
                    this.minecraft.soundEngine.playUI("random.click", 1.0f, 1.0f);
                    this.buttonClicked(button);
                }
                ++i;
            }
        }
    }

    protected void mouseReleased(int x, int y, int buttonNum) {
        if (this.clickedButton != null && buttonNum == 0) {
            this.clickedButton.released(x, y);
            this.clickedButton = null;
        }
    }

    protected void buttonClicked(Button button) {
    }

    public void init(Minecraft minecraft, int width, int height) {
        this.minecraft = minecraft;
        this.font = minecraft.font;
        this.width = width;
        this.height = height;
        this.buttons.clear();
        this.init();
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void init() {
    }

    public void updateEvents() {
        while (Mouse.next()) {
            this.mouseEvent();
        }
        while (Keyboard.next()) {
            this.keyboardEvent();
        }
    }

    public void mouseEvent() {
        if (Mouse.getEventButtonState()) {
            int xm = Mouse.getEventX() * this.width / this.minecraft.width;
            int ym = this.height - Mouse.getEventY() * this.height / this.minecraft.height - 1;
            this.mouseClicked(xm, ym, Mouse.getEventButton());
        } else {
            int xm = Mouse.getEventX() * this.width / this.minecraft.width;
            int ym = this.height - Mouse.getEventY() * this.height / this.minecraft.height - 1;
            this.mouseReleased(xm, ym, Mouse.getEventButton());
        }
    }

    public void keyboardEvent() {
        if (Keyboard.getEventKeyState()) {
            if (Keyboard.getEventKey() == 87) {
                this.minecraft.toggleFullScreen();
                return;
            }
            this.keyPressed(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
    }

    public void tick() {
    }

    public void removed() {
    }

    public void renderBackground() {
        this.renderBackground(0);
    }

    public void renderBackground(int vo) {
        if (this.minecraft.level != null) {
            this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        } else {
            this.renderDirtBackground(vo);
        }
    }

    public void renderDirtBackground(int vo) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tesselator t = Tesselator.instance;
        GL11.glBindTexture((int)3553, (int)this.minecraft.textures.loadTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float s = 32.0f;
        t.begin();
        t.color(0x404040);
        t.vertexUV(0.0, this.height, 0.0, 0.0, (float)this.height / s + (float)vo);
        t.vertexUV(this.width, this.height, 0.0, (float)this.width / s, (float)this.height / s + (float)vo);
        t.vertexUV(this.width, 0.0, 0.0, (float)this.width / s, 0 + vo);
        t.vertexUV(0.0, 0.0, 0.0, 0.0, 0 + vo);
        t.end();
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void confirmResult(boolean result, int id) {
    }
}

