/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Options;
import net.minecraft.client.gui.Button;
import net.minecraft.client.gui.ControlsScreen;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.SlideButton;
import net.minecraft.client.gui.SmallButton;
import net.minecraft.client.locale.Language;

public class OptionsScreen
extends Screen {
    private Screen lastScreen;
    protected String title = "Options";
    private Options options;

    public OptionsScreen(Screen lastScreen, Options options) {
        this.lastScreen = lastScreen;
        this.options = options;
    }

    @Override
    public void init() {
        Language language = Language.getInstance();
        this.title = language.getElement("options.title");
        Options.Option[] optionArray = Options.Option.values();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Options.Option item = optionArray[n2];
            int position = item.getId();
            if (!item.isProgress()) {
                this.buttons.add(new SmallButton(item.getId(), this.width / 2 - 155 + position % 2 * 160, this.height / 6 + 24 * (position >> 1), item, this.options.getMessage(item)));
            } else {
                this.buttons.add(new SlideButton(item.getId(), this.width / 2 - 155 + position % 2 * 160, this.height / 6 + 24 * (position >> 1), item, this.options.getMessage(item), this.options.getProgressValue(item)));
            }
            ++n2;
        }
        this.buttons.add(new Button(100, this.width / 2 - 100, this.height / 6 + 120 + 12, language.getElement("options.controls")));
        this.buttons.add(new Button(200, this.width / 2 - 100, this.height / 6 + 168, language.getElement("gui.done")));
    }

    @Override
    protected void buttonClicked(Button button) {
        if (!button.active) {
            return;
        }
        if (button.id < 100 && button instanceof SmallButton) {
            this.options.toggle(((SmallButton)button).getOption(), 1);
            button.msg = this.options.getMessage(Options.Option.getItem(button.id));
        }
        if (button.id == 100) {
            this.minecraft.options.save();
            this.minecraft.setScreen(new ControlsScreen(this, this.options));
        }
        if (button.id == 200) {
            this.minecraft.options.save();
            this.minecraft.setScreen(this.lastScreen);
        }
    }

    @Override
    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        super.render(xm, ym, a);
    }
}

