/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.Tesselator;
import org.lwjgl.opengl.GL11;

public class GuiComponent {
    protected float blitOffset = 0.0f;

    protected void fill(int x0, int y0, int x1, int y1, int col) {
        float a = (float)(col >> 24 & 0xFF) / 255.0f;
        float r = (float)(col >> 16 & 0xFF) / 255.0f;
        float g = (float)(col >> 8 & 0xFF) / 255.0f;
        float b = (float)(col & 0xFF) / 255.0f;
        Tesselator t = Tesselator.instance;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        t.begin();
        t.vertex(x0, y1, 0.0);
        t.vertex(x1, y1, 0.0);
        t.vertex(x1, y0, 0.0);
        t.vertex(x0, y0, 0.0);
        t.end();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    protected void fillGradient(int x0, int y0, int x1, int y1, int col1, int col2) {
        float a1 = (float)(col1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(col1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(col1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(col1 & 0xFF) / 255.0f;
        float a2 = (float)(col2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(col2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(col2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(col2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tesselator t = Tesselator.instance;
        t.begin();
        t.color(r1, g1, b1, a1);
        t.vertex(x1, y0, 0.0);
        t.vertex(x0, y0, 0.0);
        t.color(r2, g2, b2, a2);
        t.vertex(x0, y1, 0.0);
        t.vertex(x1, y1, 0.0);
        t.end();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public void drawCenteredString(Font font, String str, int x, int y, int color) {
        font.drawShadow(str, x - font.width(str) / 2, y, color);
    }

    public void drawString(Font font, String str, int x, int y, int color) {
        font.drawShadow(str, x, y, color);
    }

    public void blit(int x, int y, int sx, int sy, int w, int h) {
        float us = 0.00390625f;
        float vs = 0.00390625f;
        Tesselator t = Tesselator.instance;
        t.begin();
        t.vertexUV(x + 0, y + h, this.blitOffset, (float)(sx + 0) * us, (float)(sy + h) * vs);
        t.vertexUV(x + w, y + h, this.blitOffset, (float)(sx + w) * us, (float)(sy + h) * vs);
        t.vertexUV(x + w, y + 0, this.blitOffset, (float)(sx + w) * us, (float)(sy + 0) * vs);
        t.vertexUV(x + 0, y + 0, this.blitOffset, (float)(sx + 0) * us, (float)(sy + 0) * vs);
        t.end();
    }
}

