/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Lighting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatScreen;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.ScreenSizeCalculator;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class Gui
extends GuiComponent {
    private static final int MAX_MESSAGE_WIDTH = 320;
    private static ItemRenderer itemRenderer = new ItemRenderer();
    private List<GuiMessage> guiMessages = new ArrayList<GuiMessage>();
    private Random random = new Random();
    private Minecraft minecraft;
    public String selectedName = null;
    private int tickCount = 0;
    private String nowPlayingString = "";
    private int nowPlayingTime = 0;
    public float progress;
    float tbr = 1.0f;

    public Gui(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void render(float f, boolean bl, int n, int n2) {
        String string;
        int n3;
        int n4;
        int n5;
        boolean bl2;
        float f2;
        ScreenSizeCalculator screenSizeCalculator = new ScreenSizeCalculator(this.minecraft.width, this.minecraft.height);
        int n6 = screenSizeCalculator.getWidth();
        int n7 = screenSizeCalculator.getHeight();
        Font font = this.minecraft.font;
        this.minecraft.gameRenderer.setupGuiScreen();
        GL11.glEnable((int)3042);
        if (this.minecraft.options.fancyGraphics) {
            this.renderVignette(this.minecraft.player.getBrightness(f), n6, n7);
        }
        ItemInstance itemInstance = this.minecraft.player.inventory.getArmor(3);
        if (!this.minecraft.options.thirdPersonView && itemInstance != null && itemInstance.id == Tile.pumpkin.id) {
            this.renderPumpkin(n6, n7);
        }
        if ((f2 = this.minecraft.player.oPortalTime + (this.minecraft.player.portalTime - this.minecraft.player.oPortalTime) * f) > 0.0f) {
            this.renderTp(f2, n6, n7);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)this.minecraft.textures.loadTexture("/gui/gui.png"));
        Inventory inventory = this.minecraft.player.inventory;
        this.blitOffset = -90.0f;
        this.blit(n6 / 2 - 91, n7 - 22, 0, 0, 182, 22);
        this.blit(n6 / 2 - 91 - 1 + inventory.selected * 20, n7 - 22 - 1, 0, 22, 24, 22);
        GL11.glBindTexture((int)3553, (int)this.minecraft.textures.loadTexture("/gui/icons.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)775, (int)769);
        this.blit(n6 / 2 - 7, n7 / 2 - 7, 0, 0, 16, 16);
        GL11.glDisable((int)3042);
        boolean bl3 = bl2 = this.minecraft.player.invulnerableTime / 3 % 2 == 1;
        if (this.minecraft.player.invulnerableTime < 10) {
            bl2 = false;
        }
        int n8 = this.minecraft.player.health;
        int n9 = this.minecraft.player.lastHealth;
        this.random.setSeed(this.tickCount * 312871);
        if (this.minecraft.gameMode.canHurtPlayer()) {
            int n10;
            n5 = this.minecraft.player.getArmor();
            for (n4 = 0; n4 < 10; ++n4) {
                n3 = n7 - 32;
                if (n5 > 0) {
                    n10 = n6 / 2 + 91 - n4 * 8 - 9;
                    if (n4 * 2 + 1 < n5) {
                        this.blit(n10, n3, 34, 9, 9, 9);
                    }
                    if (n4 * 2 + 1 == n5) {
                        this.blit(n10, n3, 25, 9, 9, 9);
                    }
                    if (n4 * 2 + 1 > n5) {
                        this.blit(n10, n3, 16, 9, 9, 9);
                    }
                }
                n10 = 0;
                if (bl2) {
                    n10 = 1;
                }
                int n11 = n6 / 2 - 91 + n4 * 8;
                if (n8 <= 4) {
                    n3 += this.random.nextInt(2);
                }
                this.blit(n11, n3, 16 + n10 * 9, 0, 9, 9);
                if (bl2) {
                    if (n4 * 2 + 1 < n9) {
                        this.blit(n11, n3, 70, 0, 9, 9);
                    }
                    if (n4 * 2 + 1 == n9) {
                        this.blit(n11, n3, 79, 0, 9, 9);
                    }
                }
                if (n4 * 2 + 1 < n8) {
                    this.blit(n11, n3, 52, 0, 9, 9);
                }
                if (n4 * 2 + 1 != n8) continue;
                this.blit(n11, n3, 61, 0, 9, 9);
            }
            if (this.minecraft.player.isUnderLiquid(Material.water)) {
                n4 = (int)Math.ceil((double)(this.minecraft.player.airSupply - 2) * 10.0 / 300.0);
                n3 = (int)Math.ceil((double)this.minecraft.player.airSupply * 10.0 / 300.0) - n4;
                for (n10 = 0; n10 < n4 + n3; ++n10) {
                    if (n10 < n4) {
                        this.blit(n6 / 2 - 91 + n10 * 8, n7 - 32 - 9, 16, 18, 9, 9);
                        continue;
                    }
                    this.blit(n6 / 2 - 91 + n10 * 8, n7 - 32 - 9, 25, 18, 9, 9);
                }
            }
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)32826);
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Lighting.turnOn();
        GL11.glPopMatrix();
        for (n5 = 0; n5 < 9; ++n5) {
            n4 = n6 / 2 - 90 + n5 * 20 + 2;
            n3 = n7 - 16 - 3;
            this.renderSlot(n5, n4, n3, f);
        }
        Lighting.turnOff();
        GL11.glDisable((int)32826);
        if (Keyboard.isKeyDown((int)61)) {
            font.drawShadow("Minecraft Beta 1.2_02 (" + this.minecraft.fpsString + ")", 2, 2, 0xFFFFFF);
            font.drawShadow(this.minecraft.gatherStats1(), 2, 12, 0xFFFFFF);
            font.drawShadow(this.minecraft.gatherStats2(), 2, 22, 0xFFFFFF);
            font.drawShadow(this.minecraft.gatherStats3(), 2, 32, 0xFFFFFF);
            font.drawShadow(this.minecraft.gatherStats4(), 2, 42, 0xFFFFFF);
            long l = Runtime.getRuntime().maxMemory();
            long l2 = Runtime.getRuntime().totalMemory();
            long l3 = Runtime.getRuntime().freeMemory();
            long l4 = l2 - l3;
            string = "Used memory: " + l4 * 100L / l + "% (" + l4 / 1024L / 1024L + "MB) of " + l / 1024L / 1024L + "MB";
            this.drawString(font, string, n6 - font.width(string) - 2, 2, 0xE0E0E0);
            string = "Allocated memory: " + l2 * 100L / l + "% (" + l2 / 1024L / 1024L + "MB)";
            this.drawString(font, string, n6 - font.width(string) - 2, 12, 0xE0E0E0);
            this.drawString(font, "x: " + this.minecraft.player.x, 2, 64, 0xE0E0E0);
            this.drawString(font, "y: " + this.minecraft.player.y, 2, 72, 0xE0E0E0);
            this.drawString(font, "z: " + this.minecraft.player.z, 2, 80, 0xE0E0E0);
            this.drawString(font, "xRot: " + this.minecraft.player.xRot, 2, 88, 0xE0E0E0);
            this.drawString(font, "yRot: " + this.minecraft.player.yRot, 2, 96, 0xE0E0E0);
            this.drawString(font, "tilt: " + this.minecraft.player.tilt, 2, 104, 0xE0E0E0);
        } else {
            font.drawShadow("Minecraft Beta 1.2_02", 2, 2, 0xFFFFFF);
        }
        if (this.nowPlayingTime > 0) {
            float f3 = (float)this.nowPlayingTime - f;
            n4 = (int)(f3 * 256.0f / 20.0f);
            if (n4 > 255) {
                n4 = 255;
            }
            if (n4 > 0) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(n6 / 2), (float)(n7 - 48), (float)0.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                int n12 = Color.HSBtoRGB(f3 / 50.0f, 0.7f, 0.6f) & 0xFFFFFF;
                font.draw(this.nowPlayingString, -font.width(this.nowPlayingString) / 2, -4, n12 + (n4 << 24));
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
        }
        int n13 = 10;
        n4 = 0;
        if (this.minecraft.screen instanceof ChatScreen) {
            n13 = 20;
            n4 = 1;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(n7 - 48), (float)0.0f);
        for (int i = 0; i < this.guiMessages.size() && i < n13; ++i) {
            if (this.guiMessages.get((int)i).ticks >= 200 && n4 == 0) continue;
            double d = (double)this.guiMessages.get((int)i).ticks / 200.0;
            d = 1.0 - d;
            if ((d *= 10.0) < 0.0) {
                d = 0.0;
            }
            if (d > 1.0) {
                d = 1.0;
            }
            d *= d;
            int n14 = (int)(255.0 * d);
            if (n4 != 0) {
                n14 = 255;
            }
            if (n14 <= 0) continue;
            int n15 = 2;
            int n16 = -i * 9;
            string = this.guiMessages.get((int)i).string;
            this.fill(n15, n16 - 1, n15 + 320, n16 + 8, n14 / 2 << 24);
            GL11.glEnable((int)3042);
            font.drawShadow(string, n15, n16, 0xFFFFFF + (n14 << 24));
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    private void renderPumpkin(int n, int n2) {
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        GL11.glBindTexture((int)3553, (int)this.minecraft.textures.loadTexture("%blur%/misc/pumpkinblur.png"));
        Tesselator tesselator = Tesselator.instance;
        tesselator.begin();
        tesselator.vertexUV(0.0, n2, -90.0, 0.0, 1.0);
        tesselator.vertexUV(n, n2, -90.0, 1.0, 1.0);
        tesselator.vertexUV(n, 0.0, -90.0, 1.0, 0.0);
        tesselator.vertexUV(0.0, 0.0, -90.0, 0.0, 0.0);
        tesselator.end();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderVignette(float f, int n, int n2) {
        if ((f = 1.0f - f) < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.tbr = (float)((double)this.tbr + (double)(f - this.tbr) * 0.01);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)0, (int)769);
        GL11.glColor4f((float)this.tbr, (float)this.tbr, (float)this.tbr, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)this.minecraft.textures.loadTexture("%blur%/misc/vignette.png"));
        Tesselator tesselator = Tesselator.instance;
        tesselator.begin();
        tesselator.vertexUV(0.0, n2, -90.0, 0.0, 1.0);
        tesselator.vertexUV(n, n2, -90.0, 1.0, 1.0);
        tesselator.vertexUV(n, 0.0, -90.0, 1.0, 0.0);
        tesselator.vertexUV(0.0, 0.0, -90.0, 0.0, 0.0);
        tesselator.end();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private void renderTp(float f, int n, int n2) {
        f *= f;
        f *= f;
        f = f * 0.8f + 0.2f;
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
        GL11.glBindTexture((int)3553, (int)this.minecraft.textures.loadTexture("/terrain.png"));
        float f2 = (float)(Tile.portalTile.tex % 16) / 16.0f;
        float f3 = (float)(Tile.portalTile.tex / 16) / 16.0f;
        float f4 = (float)(Tile.portalTile.tex % 16 + 1) / 16.0f;
        float f5 = (float)(Tile.portalTile.tex / 16 + 1) / 16.0f;
        Tesselator tesselator = Tesselator.instance;
        tesselator.begin();
        tesselator.vertexUV(0.0, n2, -90.0, f2, f5);
        tesselator.vertexUV(n, n2, -90.0, f4, f5);
        tesselator.vertexUV(n, 0.0, -90.0, f4, f3);
        tesselator.vertexUV(0.0, 0.0, -90.0, f2, f3);
        tesselator.end();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderSlot(int n, int n2, int n3, float f) {
        ItemInstance itemInstance = this.minecraft.player.inventory.items[n];
        if (itemInstance == null) {
            return;
        }
        float f2 = (float)itemInstance.popTime - f;
        if (f2 > 0.0f) {
            GL11.glPushMatrix();
            float f3 = 1.0f + f2 / 5.0f;
            GL11.glTranslatef((float)(n2 + 8), (float)(n3 + 12), (float)0.0f);
            GL11.glScalef((float)(1.0f / f3), (float)((f3 + 1.0f) / 2.0f), (float)1.0f);
            GL11.glTranslatef((float)(-(n2 + 8)), (float)(-(n3 + 12)), (float)0.0f);
        }
        itemRenderer.renderGuiItem(this.minecraft.font, this.minecraft.textures, itemInstance, n2, n3);
        if (f2 > 0.0f) {
            GL11.glPopMatrix();
        }
        itemRenderer.renderGuiItemDecorations(this.minecraft.font, this.minecraft.textures, itemInstance, n2, n3);
    }

    public void tick() {
        if (this.nowPlayingTime > 0) {
            --this.nowPlayingTime;
        }
        ++this.tickCount;
        for (int i = 0; i < this.guiMessages.size(); ++i) {
            ++this.guiMessages.get((int)i).ticks;
        }
    }

    public void addMessage(String string) {
        while (this.minecraft.font.width(string) > 320) {
            int n;
            for (n = 1; n < string.length() && this.minecraft.font.width(string.substring(0, n + 1)) <= 320; ++n) {
            }
            this.addMessage(string.substring(0, n));
            string = string.substring(n);
        }
        this.guiMessages.add(0, new GuiMessage(string));
        while (this.guiMessages.size() > 50) {
            this.guiMessages.remove(this.guiMessages.size() - 1);
        }
    }

    public void setNowPlaying(String string) {
        this.nowPlayingString = "Now playing: " + string;
        this.nowPlayingTime = 60;
    }
}

