/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import net.minecraft.SharedConstants;
import net.minecraft.client.MemoryTracker;
import net.minecraft.client.Options;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.renderer.Textures;
import org.lwjgl.opengl.GL11;

public class Font {
    private int[] charWidths = new int[256];
    public int fontTexture = 0;
    private int listPos;
    private IntBuffer ib = MemoryTracker.createIntBuffer(1024);

    public Font(Options options, String name, Textures textures) {
        BufferedImage img;
        try {
            img = ImageIO.read(Textures.class.getResourceAsStream(name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int w = img.getWidth();
        int h = img.getHeight();
        int[] rawPixels = new int[w * h];
        img.getRGB(0, 0, w, h, rawPixels, 0, w);
        int i = 0;
        while (i < 256) {
            int xt = i % 16;
            int yt = i / 16;
            int x = 7;
            while (x >= 0) {
                int xPixel = xt * 8 + x;
                boolean emptyColumn = true;
                int y = 0;
                while (y < 8 && emptyColumn) {
                    int yPixel = (yt * 8 + y) * w;
                    int pixel = rawPixels[xPixel + yPixel] & 0xFF;
                    if (pixel > 0) {
                        emptyColumn = false;
                    }
                    ++y;
                }
                if (!emptyColumn) break;
                --x;
            }
            if (i == 32) {
                x = 2;
            }
            this.charWidths[i] = x + 2;
            ++i;
        }
        this.fontTexture = textures.getTexture(img);
        this.listPos = MemoryTracker.genLists(288);
        Tesselator t = Tesselator.instance;
        int i2 = 0;
        while (i2 < 256) {
            GL11.glNewList((int)(this.listPos + i2), (int)4864);
            t.begin();
            int ix = i2 % 16 * 8;
            int iy = i2 / 16 * 8;
            float s = 7.99f;
            float uo = 0.0f;
            float vo = 0.0f;
            t.vertexUV(0.0, 0.0f + s, 0.0, (float)ix / 128.0f + uo, ((float)iy + s) / 128.0f + vo);
            t.vertexUV(0.0f + s, 0.0f + s, 0.0, ((float)ix + s) / 128.0f + uo, ((float)iy + s) / 128.0f + vo);
            t.vertexUV(0.0f + s, 0.0, 0.0, ((float)ix + s) / 128.0f + uo, (float)iy / 128.0f + vo);
            t.vertexUV(0.0, 0.0, 0.0, (float)ix / 128.0f + uo, (float)iy / 128.0f + vo);
            t.end();
            GL11.glTranslatef((float)this.charWidths[i2], (float)0.0f, (float)0.0f);
            GL11.glEndList();
            ++i2;
        }
        i2 = 0;
        while (i2 < 32) {
            boolean darken;
            int br = (i2 >> 3 & 1) * 85;
            int r = (i2 >> 2 & 1) * 170 + br;
            int g = (i2 >> 1 & 1) * 170 + br;
            int b = (i2 >> 0 & 1) * 170 + br;
            if (i2 == 6) {
                r += 85;
            }
            boolean bl = darken = i2 >= 16;
            if (options.anaglyph3d) {
                int cr = (r * 30 + g * 59 + b * 11) / 100;
                int cg = (r * 30 + g * 70) / 100;
                int cb = (r * 30 + b * 70) / 100;
                r = cr;
                g = cg;
                b = cb;
            }
            if (darken) {
                r /= 4;
                g /= 4;
                b /= 4;
            }
            GL11.glNewList((int)(this.listPos + 256 + i2), (int)4864);
            GL11.glColor3f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f));
            GL11.glEndList();
            ++i2;
        }
    }

    public void drawShadow(String str, int x, int y, int color) {
        this.draw(str, x + 1, y + 1, color, true);
        this.draw(str, x, y, color);
    }

    public void draw(String str, int x, int y, int color) {
        this.draw(str, x, y, color, false);
    }

    /*
     * Exception decompiling
     */
    public void draw(String str, int x, int y, int color, boolean darken) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int width(String str) {
        if (str == null) {
            return 0;
        }
        int len = 0;
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\u00df') {
                ++i;
            } else {
                int ch = SharedConstants.acceptableLetters.indexOf(str.charAt(i));
                if (ch >= 0) {
                    len += this.charWidths[ch + 32];
                }
            }
            ++i;
        }
        return len;
    }

    public static String sanitize(String str) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\u00df') {
                ++i;
            } else if (SharedConstants.acceptableLetters.indexOf(str.charAt(i)) >= 0) {
                sb.append(str.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }
}

