/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gamemode.secret;

import com.mojang.nbt.CompoundTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gamemode.secret.SecretBuilderInventory;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;

public class SecretBuilder
extends Animal {
    public static final int SWING_DURATION = 8;
    public Minecraft minecraft;
    public boolean swinging = false;
    public boolean shouldSwing = false;
    public int swingTime = 0;
    public State state = State.ROAMING;
    public SecretBuilderInventory inventory = new SecretBuilderInventory();

    public SecretBuilder(Level level) {
        super(level);
        this.textureName = "/mob/char.png";
        this.modelName = "humanoid";
        this.setSize(0.6f, 1.8f);
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        super.addAdditonalSaveData(compoundTag);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
    }

    public void swing() {
        this.swingTime = -1;
        this.swinging = true;
    }

    protected void updateAi() {
        System.out.println("Our block is: " + this.minecraft.level.getTile(-34, 74, 0));
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime == 8) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / 8.0f;
        super.updateAi();
    }

    public ItemInstance getCarriedItem() {
        return this.inventory.getSelected();
    }

    public void aiStep() {
        this.attackTarget = this.minecraft.player;
        if (!this.swinging && this.shouldSwing) {
            this.swing();
        }
        super.aiStep();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        BUILDING,
        MOVING,
        ROAMING;

    }
}

