/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gamemode.secret;

import com.mojang.nbt.CompoundTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gamemode.secret.BuilderInventory;
import net.minecraft.client.gamemode.secret.Schematic;
import net.minecraft.client.gamemode.secret.SecretMode;
import net.minecraft.client.gamemode.secret.Waypoint;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.Vec3;
import util.Mth;

public class Builder
extends PathfinderMob {
    private static final int MAX_TURN = 30;
    private static final int BUILD_TIME = 10;
    private static final float BUILD_RANGE = 3.0f;
    private static final int MAX_STUCK_COUNT = 20;
    private static final int PUSH_COOLDOWN = 50;
    public static final int SWING_DURATION = 8;
    public Minecraft minecraft;
    public boolean swinging = false;
    public boolean shouldSwing = false;
    public int swingTime = 0;
    public State state = State.ROAMING;
    public Waypoint buildTarget;
    public static final Schematic schema = new Schematic();
    public static final int xSchemaOrigin = 113;
    public static final int ySchemaOrigin = 72;
    public static final int zSchemaOrigin = 139;
    public int xold;
    public int zold;
    public int xlaststuck;
    public int zlaststuck = 0;
    public int stuckCount = 0;
    public int pushStep = 50;
    public int age = 0;
    public static boolean initialized = false;
    private int buildStep = 0;
    private boolean verbose = false;
    public BuilderInventory inventory = new BuilderInventory();
    private Path path;

    public Builder(Level level) {
        super(level);
        this.textureName = "/mob/char.png";
        this.modelName = "humanoid";
        this.setSize(0.6f, 1.8f);
    }

    public void addAdditonalSaveData(CompoundTag compoundTag) {
        super.addAdditonalSaveData(compoundTag);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
    }

    public void swing() {
        this.swingTime = -1;
        this.swinging = true;
    }

    protected Entity findAttackTarget() {
        if (this.state != State.MOVING || this.buildTarget == null || this.buildTarget.distanceTo(this) < 2.0f) {
            return null;
        }
        return this.buildTarget;
    }

    public void setBuildTarget(int n, int n2, int n3, int n4) {
        int n5;
        if (this.buildTarget != null && this.buildTarget instanceof Waypoint) {
            this.level.removeEntity(this.buildTarget);
            this.buildTarget = null;
        }
        Waypoint waypoint = new Waypoint(this.level);
        waypoint.targetTile = n4;
        waypoint.setPos(n, n2, n3);
        this.buildTarget = waypoint;
        this.attackTarget = this.buildTarget;
        if (this.verbose) {
            System.out.println("Build target set to " + n4 + " at " + n + ", " + n2 + ", " + n3);
        }
        if (this.buildTarget.y < (double)((n5 = (int)Math.floor(this.bb.y0)) - 1)) {
            Vec3 vec3 = Vec3.newTemp(this.x, this.y, this.z).vectorTo(Vec3.newTemp(this.buildTarget.x, this.buildTarget.y, this.buildTarget.z)).normalize();
            this.push(vec3.x * (double)0.6f, 0.4f, vec3.z * (double)0.6f);
        }
    }

    private int getStackHeight(int n, int n2) {
        int n3 = 0;
        while (this.level.getTile(n, n3 + 1, n2) != 0 || this.level.getTile(n, n3 + 2, n2) != 0 || this.level.getTile(n, n3 + 3, n2) != 0) {
            ++n3;
        }
        return n3;
    }

    private int getHeighestNeighborStack() {
        int n = (int)Math.floor(this.x);
        int n2 = (int)Math.floor(this.z);
        int n3 = 0;
        if (this.getStackHeight(n + 1, n2) > n3) {
            n3 = this.getStackHeight(n + 1, n2);
        }
        if (this.getStackHeight(n, n2 + 1) > n3) {
            n3 = this.getStackHeight(n, n2 + 1);
        }
        if (this.getStackHeight(n - 1, n2 + 1) > n3) {
            n3 = this.getStackHeight(n - 1, n2 + 1);
        }
        if (this.getStackHeight(n - 1, n2) > n3) {
            n3 = this.getStackHeight(n - 1, n2);
        }
        if (this.getStackHeight(n - 1, n2 - 1) > n3) {
            n3 = this.getStackHeight(n - 1, n2 - 1);
        }
        if (this.getStackHeight(n + 1, n2 + 1) > n3) {
            n3 = this.getStackHeight(n + 1, n2 + 1);
        }
        if (this.getStackHeight(n, n2 - 1) > n3) {
            n3 = this.getStackHeight(n, n2 - 1);
        }
        if (this.getStackHeight(n + 1, n2 - 1) > n3) {
            n3 = this.getStackHeight(n + 1, n2 - 1);
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    protected void updateAi() {
        ++this.age;
        if (!Builder.initialized) {
            Builder.initialized = true;
            for (var1_1 = Builder.schema.start[0].length - 1; var1_1 > 0; --var1_1) {
                for (var2_3 = 0; var2_3 < Builder.schema.start.length; ++var2_3) {
                    for (var3_4 = 0; var3_4 < Builder.schema.start[var2_3][var1_1].length; ++var3_4) {
                        if (Builder.schema.start[var2_3][var1_1][var3_4] == 0) continue;
                        this.level.setTile(113 + var2_3, 72 + var1_1, 139 + var3_4, Builder.schema.start[var2_3][var1_1][var3_4]);
                        var4_5 = 0;
                        while (this.level.getTile(113 + var2_3, 72 + var1_1 - var4_5 - 1, 139 + var3_4) == 0) {
                            this.level.setTile(113 + var2_3, 72 + var1_1 - ++var4_5, 139 + var3_4, 5);
                        }
                    }
                }
            }
        }
        this.health = 20;
        if (this.pushStep < 50) {
            --this.pushStep;
            if (this.pushStep <= 0) {
                this.pushStep = 50;
            }
        }
        var1_2 = 40.0f;
        this.jumping = false;
        var2_3 = (int)Math.floor(this.x);
        var3_4 = (int)Math.floor(this.bb.y0);
        var4_5 = (int)Math.floor(this.z);
        if (this.age > 3000 && this.random.nextInt(500) == 0) {
            var5_6 = (SecretMode)this.minecraft.gameMode;
            this.level.explode(this, var2_3, var3_4, var4_5, 1.0f);
            this.level.removeEntity(this);
            var5_6.spawnBuilder();
        }
        if (this.level.getTile(var2_3, var3_4, var4_5) != 0 || this.buildTarget != null && this.buildTarget.x == (double)var2_3 && this.buildTarget.z == (double)var4_5) {
            this.jumping = true;
        }
        if (this.pushStep == 50 && this.buildTarget != null && this.random.nextInt(300) == 0) {
            var5_6 = Vec3.newTemp(this.x, this.bb.y0, this.z).vectorTo(Vec3.newTemp(this.buildTarget.x, this.buildTarget.y, this.buildTarget.z)).normalize();
            this.push(var5_6.x * 0.5, 0.4000000059604645, var5_6.z * 0.5);
            --this.pushStep;
        }
        if (this.state == State.MOVING) {
            if (this.attackTarget == null) {
                this.attackTarget = this.findAttackTarget();
            } else if (!this.attackTarget.isAlive()) {
                this.attackTarget = null;
            } else {
                var5_7 = this.attackTarget.distanceTo(this);
                if (this.canSee(this.attackTarget)) {
                    this.checkHurtTarget(this.attackTarget, var5_7);
                }
            }
            if (this.attackTarget != null) {
                this.path = this.level.findPath(this, this.attackTarget, var1_2);
            }
        }
        if (this.state == State.MOVING || this.state == State.BUILDING) {
            this.stuckCount = Mth.floor(this.x) == this.xold && Mth.floor(this.z) == this.zold ? ++this.stuckCount : 0;
            this.xold = Mth.floor(this.x);
            this.zold = Mth.floor(this.z);
            if (this.state == State.MOVING && this.path == null || this.stuckCount >= 20) {
                this.state = State.STUCK;
                return;
            }
        }
        if (this.state == State.STUCK) {
            if (this.verbose) {
                System.out.println(System.currentTimeMillis() + " - I think I'm stuck... thinking about solution.");
            }
            if (this.verbose) {
                System.out.println("Checking if heighest neighobur stack (" + this.getHeighestNeighborStack() + ") is > " + var3_4);
            }
            if (this.getHeighestNeighborStack() > var3_4) {
                if (this.verbose) {
                    System.out.println("Building ourselves up.");
                }
                if (this.level.getTile(var2_3, var3_4 + 1, var4_5) != 0) {
                    this.level.setTile(var2_3, var3_4 + 1, var4_5, 0);
                }
                if (this.level.getTile(var2_3, var3_4 + 2, var4_5) != 0) {
                    this.level.setTile(var2_3, var3_4 + 2, var4_5, 0);
                }
                if (this.level.getTile(var2_3, var3_4 + 3, var4_5) != 0) {
                    this.level.setTile(var2_3, var3_4 + 3, var4_5, 0);
                }
                if (this.pushStep == 50) {
                    --this.pushStep;
                    this.push(Math.random() * 0.6 - 0.3, 0.4, Math.random() * 0.6 - 0.3);
                }
                this.jumping = true;
                this.level.setTile(var2_3, var3_4, var4_5, 5);
                this.stuckCount = 0;
                this.state = State.MOVING;
                return;
            }
            if (this.pushStep == 50) {
                if (this.verbose) {
                    System.out.println("Nudging ourselves");
                }
                --this.pushStep;
                this.push(Math.random() * 0.6 - 0.3, 0.5, Math.random() * 0.6 - 0.3);
                this.jumping = true;
                this.stuckCount = 0;
                this.state = State.MOVING;
                return;
            }
        }
        if (this.state != State.MOVING) ** GOTO lbl106
        if (this.attackTarget != null && this.buildTarget != null) {
            if (this.attackTarget.distanceTo(this) <= 3.0f) {
                this.state = State.BUILDING;
                this.lookAt(this.buildTarget, 30.0f);
                this.attackTarget = null;
                return;
            }
        } else {
            this.attackTarget = null;
            this.buildTarget = null;
            this.state = State.ROAMING;
            return;
lbl106:
            // 1 sources

            if (this.state == State.ROAMING) {
                if (this.buildTarget != null && this.buildTarget.distanceTo(this) > 8.0f) {
                    this.state = State.MOVING;
                    return;
                }
                for (var5_8 = 0; var5_8 < Builder.schema.target[0].length; ++var5_8) {
                    for (var6_13 = 0; var6_13 < Builder.schema.target.length; ++var6_13) {
                        for (var7_14 = 0; var7_14 < Builder.schema.target[var6_13][var5_8].length; ++var7_14) {
                            var8_15 = this.level.getTile(113 + var6_13, 72 + var5_8, 139 + var7_14);
                            if (Builder.schema.target[var6_13][var5_8][var7_14] == 0 || var8_15 == Builder.schema.target[var6_13][var5_8][var7_14]) continue;
                            var9_17 = 0;
                            while (this.level.getTile(113 + var6_13, 72 + var5_8 - var9_17 - 1, 139 + var7_14) == 0) {
                                ++var9_17;
                            }
                            if (var9_17 > 0) {
                                if (this.verbose) {
                                    System.out.println("I should build wood foundation " + var9_17 + " steps under target block, at " + (139 + var7_14) + " -- Foundation: " + (113 + var6_13) + ", " + (72 + var5_8 - var9_17) + ", " + (139 + var7_14) + ".");
                                }
                                this.setBuildTarget(113 + var6_13, 72 + var5_8 - var9_17, 139 + var7_14, 5);
                            } else {
                                if (this.verbose) {
                                    System.out.println("I should build " + Builder.schema.target[var6_13][var5_8][var7_14] + " at " + (113 + var6_13) + ", " + (72 + var5_8) + ", " + (139 + var7_14));
                                }
                                this.setBuildTarget(113 + var6_13, 72 + var5_8, 139 + var7_14, Builder.schema.target[var6_13][var5_8][var7_14]);
                            }
                            this.state = State.BUILDING;
                            if (this.buildTarget != null) {
                                this.lookAt(this.buildTarget, 30.0f);
                            }
                            return;
                        }
                    }
                }
                for (var5_8 = Builder.schema.target[0].length - 1; var5_8 > 0; --var5_8) {
                    for (var6_13 = 0; var6_13 < Builder.schema.target.length; ++var6_13) {
                        for (var7_14 = 0; var7_14 < Builder.schema.target[var6_13][var5_8].length; ++var7_14) {
                            var8_15 = this.level.getTile(113 + var6_13, 72 + var5_8, 139 + var7_14);
                            if (Builder.schema.target[var6_13][var5_8][var7_14] != 0 || var8_15 == Builder.schema.target[var6_13][var5_8][var7_14]) continue;
                            if (this.verbose) {
                                System.out.println("I should build " + Builder.schema.target[var6_13][var5_8][var7_14] + " at " + (113 + var6_13) + ", " + (72 + var5_8) + ", " + (139 + var7_14));
                            }
                            this.setBuildTarget(113 + var6_13, 72 + var5_8, 139 + var7_14, Builder.schema.target[var6_13][var5_8][var7_14]);
                            this.state = State.BUILDING;
                            if (this.buildTarget != null) {
                                this.lookAt(this.buildTarget, 30.0f);
                            }
                            return;
                        }
                    }
                }
                if (this.verbose) {
                    System.out.println("Looks like schematic is complete, let's see if there's any excess wood to destroy");
                }
                var5_8 = 15;
                for (var6_13 = Builder.schema.target[0].length + var5_8; var6_13 >= -(Builder.schema.target[0].length + var5_8); --var6_13) {
                    for (var7_14 = -var5_8; var7_14 < Builder.schema.target.length + var5_8; ++var7_14) {
                        for (var8_15 = -var5_8; var8_15 < Builder.schema.target[0][0].length + var5_8; ++var8_15) {
                            var9_18 = this.level.getTile(113 + var7_14, 72 + var6_13, 139 + var8_15);
                            if (var9_18 != 5) continue;
                            var10_21 = 0;
                            while (this.level.getTile(113 + var7_14, 72 + var6_13 - var10_21 - 1, 139 + var8_15) == 0) {
                                ++var10_21;
                            }
                            if (var10_21 > 0) {
                                this.setBuildTarget(113 + var7_14, 72 + var6_13 - var10_21, 139 + var8_15, 5);
                            } else {
                                this.setBuildTarget(113 + var7_14, 72 + var6_13, 139 + var8_15, 0);
                            }
                            this.state = State.BUILDING;
                            if (this.buildTarget != null) {
                                this.lookAt(this.buildTarget, 30.0f);
                            }
                            return;
                        }
                    }
                }
                this.attackTarget = null;
                this.buildTarget = null;
                if (this.verbose) {
                    System.out.println("Forever roaming");
                }
            } else if (this.state == State.BUILDING) {
                if (this.buildTarget == null) {
                    this.state = State.ROAMING;
                    return;
                }
                if (this.buildTarget.distanceTo(this) > 3.0f) {
                    this.shouldSwing = false;
                    this.holdGround = false;
                    this.state = State.MOVING;
                    return;
                }
                this.holdGround = true;
                this.shouldSwing = true;
                this.jumping = false;
                if (this.buildStep < 10) {
                    ++this.buildStep;
                } else {
                    this.buildStep = 0;
                    if (this.buildStep == 0 && this.verbose) {
                        System.out.println("Building at " + (int)Math.floor(this.buildTarget.x) + ", " + (int)Math.floor(this.buildTarget.y) + ", " + (int)Math.floor(this.buildTarget.z));
                    }
                    if ((var8_15 = this.level.getTile(var5_9 = (int)Math.floor(this.buildTarget.x), var6_13 = (int)Math.floor(this.buildTarget.y), var7_14 = (int)Math.floor(this.buildTarget.z))) != 0 && this.buildTarget.targetTile != var8_15) {
                        if (this.verbose) {
                            System.out.println("This tile is something it shouldn't be, destroying it...");
                        }
                        if (this.buildTarget.targetTile != 0) {
                            Tile.tiles[var8_15].playerDestroy(this.level, var5_9, var6_13, var7_14, this.level.getData(var5_9, var6_13, var7_14));
                        }
                        this.level.setTile(var5_9, var6_13, var7_14, 0);
                        if (this.buildTarget.targetTile == 0) {
                            this.stuckCount = 0;
                            this.shouldSwing = false;
                            this.holdGround = false;
                            this.buildTarget = null;
                            this.state = State.ROAMING;
                        }
                        return;
                    }
                    if (this.buildTarget.targetTile == 0 || this.level.mayPlace(this.buildTarget.targetTile, var5_9, var6_13, var7_14, false)) {
                        if (this.verbose) {
                            System.out.println("Placing block");
                        }
                        this.level.setTile(var5_9, var6_13, var7_14, this.buildTarget.targetTile);
                    } else {
                        if (this.verbose) {
                            System.out.println("May not place here, jumping");
                        }
                        if (this.pushStep == 50) {
                            --this.pushStep;
                            this.push(0.0, 0.800000011920929, 0.0);
                        }
                        this.jumping = true;
                    }
                    var8_15 = this.level.getTile(var5_9, var6_13, var7_14);
                    if (this.buildTarget.targetTile == var8_15) {
                        if (this.verbose) {
                            System.out.println("Done building, going to roaming.");
                        }
                        this.stuckCount = 0;
                        this.shouldSwing = false;
                        this.holdGround = false;
                        this.buildTarget = null;
                        this.state = State.ROAMING;
                        return;
                    }
                }
            }
        }
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime == 8) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / 8.0f;
        if (this.attackTarget == null) {
            this.attackTarget = this.findAttackTarget();
            if (this.attackTarget != null) {
                this.path = this.level.findPath(this, this.attackTarget, var1_2);
            }
        } else if (!this.attackTarget.isAlive()) {
            this.attackTarget = null;
        } else {
            var5_10 = this.attackTarget.distanceTo(this);
            if (this.canSee(this.attackTarget)) {
                this.checkHurtTarget(this.attackTarget, var5_10);
            }
        }
        if (this.holdGround) {
            this.xxa = 0.0f;
            this.yya = 0.0f;
            this.jumping = false;
            return;
        }
        if (!(this.holdGround || this.attackTarget == null || this.path != null && this.random.nextInt(20) != 0)) {
            this.path = this.level.findPath(this, this.attackTarget, var1_2);
        } else if (this.path == null && this.random.nextInt(80) == 0 || this.random.nextInt(80) == 0) {
            var5_11 = false;
            var6_13 = -1;
            var7_14 = -1;
            var8_15 = -1;
            var9_19 = -99999.0f;
            for (var10_22 = 0; var10_22 < 10; ++var10_22) {
                var11_23 = Mth.floor(this.x + (double)this.random.nextInt(13) - 6.0);
                var14_28 = this.getWalkTargetValue(var11_23, var12_25 = Mth.floor(this.y + (double)this.random.nextInt(7) - 3.0), var13_26 = Mth.floor(this.z + (double)this.random.nextInt(13) - 6.0));
                if (!(var14_28 > var9_19)) continue;
                var9_19 = var14_28;
                var6_13 = var11_23;
                var7_14 = var12_25;
                var8_15 = var13_26;
                var5_11 = true;
            }
            if (var5_11) {
                this.path = this.level.findPath(this, var6_13, var7_14, var8_15, 10.0f);
            }
        }
        var5_12 = Mth.floor(this.bb.y0);
        var6_13 = (int)this.isInWater();
        var7_14 = (int)this.isInLava();
        this.xRot = 0.0f;
        if (this.path == null || this.random.nextInt(100) == 0) {
            super.updateAi();
            this.path = null;
            return;
        }
        var8_16 = this.path.current(this);
        var9_20 = this.bbWidth * 2.0f;
        while (var8_16 != null && var8_16.distanceToSqr(this.x, var8_16.y, this.z) < var9_20 * var9_20) {
            this.path.next();
            if (this.path.isDone()) {
                var8_16 = null;
                this.path = null;
                continue;
            }
            var8_16 = this.path.current(this);
        }
        this.jumping = false;
        if (var8_16 != null) {
            var11_24 = var8_16.x - this.x;
            var13_27 = var8_16.z - this.z;
            var15_29 = var8_16.y - (double)var5_12;
            var17_30 = (float)(Math.atan2(var13_27, var11_24) * 180.0 / 3.1415927410125732) - 90.0f;
            this.yya = this.runSpeed;
            for (var18_31 = var17_30 - this.yRot; var18_31 < -180.0f; var18_31 += 360.0f) {
            }
            while (var18_31 >= 180.0f) {
                var18_31 -= 360.0f;
            }
            if (var18_31 > 30.0f) {
                var18_31 = 30.0f;
            }
            if (var18_31 < -30.0f) {
                var18_31 = -30.0f;
            }
            this.yRot += var18_31;
            if (this.holdGround && this.attackTarget != null) {
                var19_32 = this.attackTarget.x - this.x;
                var21_33 = this.attackTarget.z - this.z;
                var23_34 = this.yRot;
                this.yRot = (float)(Math.atan2(var21_33, var19_32) * 180.0 / 3.1415927410125732) - 90.0f;
                var18_31 = (var23_34 - this.yRot + 90.0f) * 3.1415927f / 180.0f;
                this.xxa = -Mth.sin(var18_31) * this.yya * 1.0f;
                this.yya = Mth.cos(var18_31) * this.yya * 1.0f;
            }
            if (var15_29 > 0.0) {
                this.jumping = true;
            }
        }
        if (this.attackTarget != null) {
            this.lookAt(this.attackTarget, 30.0f);
        }
        if (this.horizontalCollision) {
            this.jumping = true;
        }
        if (this.random.nextFloat() < 0.8f && (var6_13 != 0 || var7_14 != 0)) {
            this.jumping = true;
        }
    }

    public ItemInstance getCarriedItem() {
        return this.inventory.getSelected();
    }

    public void aiStep() {
        if (!this.swinging && this.shouldSwing) {
            this.swing();
        }
        super.aiStep();
    }

    protected float getWalkTargetValue(int n, int n2, int n3) {
        return 10.0f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        BUILDING,
        MOVING,
        ROAMING,
        STUCK;

    }
}

