/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Screenshot {
    private static DateFormat df = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static ByteBuffer pixels;
    private static byte[] buffer;
    private static int[] pixelBuffer;
    private int rowHeight;
    private DataOutputStream dos;
    private byte[] pb;
    private int w;
    private int h;
    private File file;

    public static String grab(File workDir, int width, int height) {
        try {
            File file;
            File picDir = new File(workDir, "screenshots");
            picDir.mkdir();
            if (pixels == null || pixels.capacity() < width * height) {
                pixels = BufferUtils.createByteBuffer((int)(width * height * 3));
            }
            if (pixelBuffer == null || pixelBuffer.length < width * height * 3) {
                buffer = new byte[width * height * 3];
                pixelBuffer = new int[width * height];
            }
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glPixelStorei((int)3317, (int)1);
            pixels.clear();
            GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6407, (int)5121, (ByteBuffer)pixels);
            pixels.clear();
            String picName = df.format(new Date());
            int count = 1;
            while ((file = new File(picDir, String.valueOf(picName) + (count == 1 ? "" : "_" + count) + ".png")).exists()) {
                ++count;
            }
            pixels.get(buffer);
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    int col;
                    int i = x + (height - y - 1) * width;
                    int r = buffer[i * 3 + 0] & 0xFF;
                    int g = buffer[i * 3 + 1] & 0xFF;
                    int b = buffer[i * 3 + 2] & 0xFF;
                    Screenshot.pixelBuffer[x + y * width] = col = 0xFF000000 | r << 16 | g << 8 | b;
                    ++y;
                }
                ++x;
            }
            BufferedImage image = new BufferedImage(width, height, 1);
            image.setRGB(0, 0, width, height, pixelBuffer, 0, width);
            ImageIO.write((RenderedImage)image, "png", file);
            return "Saved screenshot as " + file.getName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Failed to save: " + e;
        }
    }

    public Screenshot(File workDir, int w, int h, int rowHeight) throws IOException {
        this.w = w;
        this.h = h;
        this.rowHeight = rowHeight;
        File picDir = new File(workDir, "screenshots");
        picDir.mkdir();
        String picName = "huge_" + df.format(new Date());
        int count = 1;
        while ((this.file = new File(picDir, String.valueOf(picName) + (count == 1 ? "" : "_" + count) + ".tga")).exists()) {
            ++count;
        }
        byte[] header = new byte[18];
        header[2] = 2;
        header[12] = (byte)(w % 256);
        header[13] = (byte)(w / 256);
        header[14] = (byte)(h % 256);
        header[15] = (byte)(h / 256);
        header[16] = 24;
        this.pb = new byte[w * rowHeight * 3];
        this.dos = new DataOutputStream(new FileOutputStream(this.file));
        this.dos.write(header);
    }

    public void addRegion(ByteBuffer pixels, int xo, int yo, int rw, int rh) {
        int ww = rw;
        int hh = rh;
        if (ww > this.w - xo) {
            ww = this.w - xo;
        }
        if (hh > this.h - yo) {
            hh = this.h - yo;
        }
        this.rowHeight = hh;
        int y = 0;
        while (y < hh) {
            pixels.position((rh - hh) * rw * 3 + y * rw * 3);
            int dp = (xo + y * this.w) * 3;
            pixels.get(this.pb, dp, ww * 3);
            ++y;
        }
    }

    public void saveRow() throws IOException {
        this.dos.write(this.pb, 0, this.w * 3 * this.rowHeight);
    }

    public String close() throws IOException {
        this.dos.close();
        return "Saved screenshot as " + this.file.getName();
    }
}

