/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.StopGameException;
import net.minecraft.client.gui.ScreenSizeCalculator;
import net.minecraft.client.renderer.Tesselator;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import util.ProgressListener;

public class ProgressRenderer
implements ProgressListener {
    private String status = "";
    private Minecraft minecraft;
    private String title = "";
    private long lastTime = System.currentTimeMillis();
    private boolean noAbort = false;

    public ProgressRenderer(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    @Override
    public void progressStart(String title) {
        this.noAbort = false;
        this._progressStart(title);
    }

    @Override
    public void progressStartNoAbort(String string) {
        this.noAbort = true;
        this._progressStart(this.title);
    }

    public void _progressStart(String title) {
        if (!this.minecraft.running) {
            if (this.noAbort) {
                return;
            }
            throw new StopGameException();
        }
        this.title = title;
        ScreenSizeCalculator ssc = new ScreenSizeCalculator(this.minecraft.width, this.minecraft.height);
        int screenWidth = ssc.getWidth();
        int screenHeight = ssc.getHeight();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)screenWidth, (double)screenHeight, (double)0.0, (double)100.0, (double)300.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
    }

    @Override
    public void progressStage(String status) {
        if (!this.minecraft.running) {
            if (this.noAbort) {
                return;
            }
            throw new StopGameException();
        }
        this.lastTime = 0L;
        this.status = status;
        this.progressStagePercentage(-1);
        this.lastTime = 0L;
    }

    @Override
    public void progressStagePercentage(int i) {
        if (!this.minecraft.running) {
            if (this.noAbort) {
                return;
            }
            throw new StopGameException();
        }
        long now = System.currentTimeMillis();
        if (now - this.lastTime < 20L) {
            return;
        }
        this.lastTime = now;
        ScreenSizeCalculator ssc = new ScreenSizeCalculator(this.minecraft.width, this.minecraft.height);
        int screenWidth = ssc.getWidth();
        int screenHeight = ssc.getHeight();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)screenWidth, (double)screenHeight, (double)0.0, (double)100.0, (double)300.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
        GL11.glClear((int)16640);
        Tesselator t = Tesselator.instance;
        int id = this.minecraft.textures.loadTexture("/gui/background.png");
        GL11.glBindTexture((int)3553, (int)id);
        float s = 32.0f;
        t.begin();
        t.color(0x404040);
        t.vertexUV(0.0, screenHeight, 0.0, 0.0, (float)screenHeight / s);
        t.vertexUV(screenWidth, screenHeight, 0.0, (float)screenWidth / s, (float)screenHeight / s);
        t.vertexUV(screenWidth, 0.0, 0.0, (float)screenWidth / s, 0.0);
        t.vertexUV(0.0, 0.0, 0.0, 0.0, 0.0);
        t.end();
        if (i >= 0) {
            int w = 100;
            int h = 2;
            int x = screenWidth / 2 - w / 2;
            int y = screenHeight / 2 + 16;
            GL11.glDisable((int)3553);
            t.begin();
            t.color(0x808080);
            t.vertex(x, y, 0.0);
            t.vertex(x, y + h, 0.0);
            t.vertex(x + w, y + h, 0.0);
            t.vertex(x + w, y, 0.0);
            t.color(0x80FF80);
            t.vertex(x, y, 0.0);
            t.vertex(x, y + h, 0.0);
            t.vertex(x + i, y + h, 0.0);
            t.vertex(x + i, y, 0.0);
            t.end();
            GL11.glEnable((int)3553);
        }
        this.minecraft.font.drawShadow(this.title, (screenWidth - this.minecraft.font.width(this.title)) / 2, screenHeight / 2 - 4 - 16, 0xFFFFFF);
        this.minecraft.font.drawShadow(this.status, (screenWidth - this.minecraft.font.width(this.status)) / 2, screenHeight / 2 - 4 + 8, 0xFFFFFF);
        Display.update();
        try {
            Thread.yield();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

