/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.locale.Language;
import org.lwjgl.input.Keyboard;

public class Options {
    private static final String[] RENDER_DISTANCE_NAMES = new String[]{"options.renderDistance.far", "options.renderDistance.normal", "options.renderDistance.short", "options.renderDistance.tiny"};
    private static final String[] DIFFICULTY_NAMES = new String[]{"options.difficulty.peaceful", "options.difficulty.easy", "options.difficulty.normal", "options.difficulty.hard"};
    public float music = 1.0f;
    public float sound = 1.0f;
    public float sensitivity = 0.5f;
    public boolean invertYMouse = false;
    public int viewDistance = 0;
    public boolean bobView = true;
    public boolean anaglyph3d = false;
    public boolean limitFramerate = false;
    public boolean fancyGraphics = true;
    public String skin = "Default";
    public KeyMapping keyUp = new KeyMapping("key.forward", 17);
    public KeyMapping keyLeft = new KeyMapping("key.left", 30);
    public KeyMapping keyDown = new KeyMapping("key.back", 31);
    public KeyMapping keyRight = new KeyMapping("key.right", 32);
    public KeyMapping keyJump = new KeyMapping("key.jump", 57);
    public KeyMapping keyFog = new KeyMapping("key.fog", 33);
    public KeyMapping keySneak = new KeyMapping("key.sneak", 42);
    public KeyMapping[] keyMappings = new KeyMapping[]{this.keyUp, this.keyLeft, this.keyDown, this.keyRight, this.keyJump, this.keySneak, this.keyFog};
    protected Minecraft minecraft;
    private File optionsFile;
    public int difficulty = 2;
    public boolean thirdPersonView = false;
    public String lastMpIp = "";

    public Options(Minecraft minecraft, File file) {
        this.minecraft = minecraft;
        this.optionsFile = new File(file, "options.txt");
        this.load();
    }

    public Options() {
    }

    public String getKeyDescription(int n) {
        Language language = Language.getInstance();
        return language.getElement(this.keyMappings[n].name);
    }

    public String getKeyMessage(int n) {
        return Keyboard.getKeyName((int)this.keyMappings[n].key);
    }

    public void setKey(int n, int n2) {
        this.keyMappings[n].key = n2;
        this.save();
    }

    public void set(Option option, float f) {
        if (option == Option.MUSIC) {
            this.music = f;
            this.minecraft.soundEngine.updateOptions();
        }
        if (option == Option.SOUND) {
            this.sound = f;
            this.minecraft.soundEngine.updateOptions();
        }
        if (option == Option.SENSITIVITY) {
            this.sensitivity = f;
        }
    }

    public void toggle(Option option, int n) {
        if (option == Option.INVERT_MOUSE) {
            boolean bl = this.invertYMouse = !this.invertYMouse;
        }
        if (option == Option.RENDER_DISTANCE) {
            this.viewDistance = this.viewDistance + n & 3;
        }
        if (option == Option.VIEW_BOBBING) {
            boolean bl = this.bobView = !this.bobView;
        }
        if (option == Option.ANAGLYPH) {
            this.anaglyph3d = !this.anaglyph3d;
            this.minecraft.textures.reloadAll();
        }
        if (option == Option.LIMIT_FRAMERATE) {
            boolean bl = this.limitFramerate = !this.limitFramerate;
        }
        if (option == Option.DIFFICULTY) {
            this.difficulty = this.difficulty + n & 3;
        }
        if (option == Option.GRAPHICS) {
            this.fancyGraphics = !this.fancyGraphics;
            this.minecraft.levelRenderer.allChanged();
        }
        this.save();
    }

    public float getProgressValue(Option option) {
        if (option == Option.MUSIC) {
            return this.music;
        }
        if (option == Option.SOUND) {
            return this.sound;
        }
        if (option == Option.SENSITIVITY) {
            return this.sensitivity;
        }
        return 0.0f;
    }

    public boolean getBooleanValue(Option option) {
        switch (option) {
            case INVERT_MOUSE: {
                return this.invertYMouse;
            }
            case VIEW_BOBBING: {
                return this.bobView;
            }
            case ANAGLYPH: {
                return this.anaglyph3d;
            }
            case LIMIT_FRAMERATE: {
                return this.limitFramerate;
            }
        }
        return false;
    }

    public String getMessage(Option option) {
        Language language = Language.getInstance();
        String string = language.getElement(option.getCaptionId()) + ": ";
        if (option.isProgress()) {
            float f = this.getProgressValue(option);
            if (option == Option.SENSITIVITY) {
                if (f == 0.0f) {
                    return string + language.getElement("options.sensitivity.min");
                }
                if (f == 1.0f) {
                    return string + language.getElement("options.sensitivity.max");
                }
                return string + (int)(f * 200.0f) + "%";
            }
            if (f == 0.0f) {
                return string + language.getElement("options.off");
            }
            return string + (int)(f * 100.0f) + "%";
        }
        if (option.isBoolean()) {
            boolean bl = this.getBooleanValue(option);
            if (bl) {
                return string + language.getElement("options.on");
            }
            return string + language.getElement("options.off");
        }
        if (option == Option.RENDER_DISTANCE) {
            return string + language.getElement(RENDER_DISTANCE_NAMES[this.viewDistance]);
        }
        if (option == Option.DIFFICULTY) {
            return string + language.getElement(DIFFICULTY_NAMES[this.difficulty]);
        }
        if (option == Option.GRAPHICS) {
            if (this.fancyGraphics) {
                return string + language.getElement("options.graphics.fancy");
            }
            return string + language.getElement("options.graphics.fast");
        }
        return string;
    }

    public void load() {
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.optionsFile));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(":");
                if (stringArray[0].equals("music")) {
                    this.music = this.readFloat(stringArray[1]);
                }
                if (stringArray[0].equals("sound")) {
                    this.sound = this.readFloat(stringArray[1]);
                }
                if (stringArray[0].equals("mouseSensitivity")) {
                    this.sensitivity = this.readFloat(stringArray[1]);
                }
                if (stringArray[0].equals("invertYMouse")) {
                    this.invertYMouse = stringArray[1].equals("true");
                }
                if (stringArray[0].equals("viewDistance")) {
                    this.viewDistance = Integer.parseInt(stringArray[1]);
                }
                if (stringArray[0].equals("bobView")) {
                    this.bobView = stringArray[1].equals("true");
                }
                if (stringArray[0].equals("anaglyph3d")) {
                    this.anaglyph3d = stringArray[1].equals("true");
                }
                if (stringArray[0].equals("limitFramerate")) {
                    this.limitFramerate = stringArray[1].equals("true");
                }
                if (stringArray[0].equals("difficulty")) {
                    this.difficulty = Integer.parseInt(stringArray[1]);
                }
                if (stringArray[0].equals("fancyGraphics")) {
                    this.fancyGraphics = stringArray[1].equals("true");
                }
                if (stringArray[0].equals("skin")) {
                    this.skin = stringArray[1];
                }
                if (stringArray[0].equals("lastServer")) {
                    this.lastMpIp = stringArray[1];
                }
                for (int i = 0; i < this.keyMappings.length; ++i) {
                    if (!stringArray[0].equals("key_" + this.keyMappings[i].name)) continue;
                    this.keyMappings[i].key = Integer.parseInt(stringArray[1]);
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to load options");
            exception.printStackTrace();
        }
    }

    private float readFloat(String string) {
        if (string.equals("true")) {
            return 1.0f;
        }
        if (string.equals("false")) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    public void save() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.optionsFile));
            printWriter.println("music:" + this.music);
            printWriter.println("sound:" + this.sound);
            printWriter.println("invertYMouse:" + this.invertYMouse);
            printWriter.println("mouseSensitivity:" + this.sensitivity);
            printWriter.println("viewDistance:" + this.viewDistance);
            printWriter.println("bobView:" + this.bobView);
            printWriter.println("anaglyph3d:" + this.anaglyph3d);
            printWriter.println("limitFramerate:" + this.limitFramerate);
            printWriter.println("difficulty:" + this.difficulty);
            printWriter.println("fancyGraphics:" + this.fancyGraphics);
            printWriter.println("skin:" + this.skin);
            printWriter.println("lastServer:" + this.lastMpIp);
            for (int i = 0; i < this.keyMappings.length; ++i) {
                printWriter.println("key_" + this.keyMappings[i].name + ":" + this.keyMappings[i].key);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to save options");
            exception.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        MUSIC("options.music", true, false),
        SOUND("options.sound", true, false),
        INVERT_MOUSE("options.invertMouse", false, true),
        SENSITIVITY("options.sensitivity", true, false),
        RENDER_DISTANCE("options.renderDistance", false, false),
        VIEW_BOBBING("options.viewBobbing", false, true),
        ANAGLYPH("options.anaglyph", false, true),
        LIMIT_FRAMERATE("options.limitFramerate", false, true),
        DIFFICULTY("options.difficulty", false, false),
        GRAPHICS("options.graphics", false, false);

        private final boolean isProgress;
        private final boolean isBoolean;
        private final String captionId;

        public static Option getItem(int n) {
            for (Option option : Option.values()) {
                if (option.getId() != n) continue;
                return option;
            }
            return null;
        }

        private Option(String string2, boolean bl, boolean bl2) {
            this.captionId = string2;
            this.isProgress = bl;
            this.isBoolean = bl2;
        }

        public boolean isProgress() {
            return this.isProgress;
        }

        public boolean isBoolean() {
            return this.isBoolean;
        }

        public int getId() {
            return this.ordinal();
        }

        public String getCaptionId() {
            return this.captionId;
        }
    }
}

