/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.minecraft.client.BackgroundDownloader;
import net.minecraft.client.CrashInfoPanel;
import net.minecraft.client.CrashReport;
import net.minecraft.client.MemoryTracker;
import net.minecraft.client.MinecraftApplet;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.OpenGLCapabilities;
import net.minecraft.client.Options;
import net.minecraft.client.ProgressRenderer;
import net.minecraft.client.Screenshot;
import net.minecraft.client.StopGameException;
import net.minecraft.client.Timer;
import net.minecraft.client.User;
import net.minecraft.client.gamemode.CreativeMode;
import net.minecraft.client.gamemode.GameMode;
import net.minecraft.client.gamemode.SurvivalMode;
import net.minecraft.client.gui.DeathScreen;
import net.minecraft.client.gui.ErrorScreen;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.LevelConflictScreen;
import net.minecraft.client.gui.PauseScreen;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenSizeCalculator;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientConnection;
import net.minecraft.client.multiplayer.ConnectScreen;
import net.minecraft.client.multiplayer.MultiplayerLocalPlayer;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Chunk;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.Tesselator;
import net.minecraft.client.renderer.Textures;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.ptexture.ClockTexture;
import net.minecraft.client.renderer.ptexture.CompassTexture;
import net.minecraft.client.renderer.ptexture.FireTexture;
import net.minecraft.client.renderer.ptexture.LavaSideTexture;
import net.minecraft.client.renderer.ptexture.LavaTexture;
import net.minecraft.client.renderer.ptexture.PortalTexture;
import net.minecraft.client.renderer.ptexture.WaterSideTexture;
import net.minecraft.client.renderer.ptexture.WaterTexture;
import net.minecraft.client.skins.TexturePackRepository;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.client.title.TitleScreen;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelConflictException;
import net.minecraft.world.level.PortalForcer;
import net.minecraft.world.level.chunk.ChunkCache;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.dimension.Dimension;
import net.minecraft.world.level.dimension.HellDimension;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import util.Mth;

public abstract class Minecraft
implements Runnable {
    public static final boolean FLYBY_MODE = false;
    public static final String VERSION_STRING = "Minecraft Beta 1.2_02";
    public GameMode gameMode;
    private boolean fullscreen = false;
    public int width;
    public int height;
    private OpenGLCapabilities openGLCapabilities;
    private Timer timer = new Timer(20.0f);
    public Level level;
    public LevelRenderer levelRenderer;
    public LocalPlayer player;
    public ParticleEngine particleEngine;
    public User user = null;
    public String serverDomain;
    public Canvas parent;
    public boolean appletMode = true;
    public volatile boolean pause = false;
    public Textures textures;
    public Font font;
    public Screen screen = null;
    public ProgressRenderer progressRenderer = new ProgressRenderer(this);
    public GameRenderer gameRenderer = new GameRenderer(this);
    private BackgroundDownloader bgLoader;
    private int ticks = 0;
    private int missTime = 0;
    private int orgWidth;
    private int orgHeight;
    public String autoLoad_user = null;
    public int autoLoad_id = 0;
    public Gui gui;
    public boolean noRender = false;
    public HumanoidModel humanoidModel = new HumanoidModel(0.0f);
    public HitResult hitResult = null;
    public Options options;
    protected MinecraftApplet minecraftApplet;
    public SoundEngine soundEngine = new SoundEngine();
    public MouseHandler mouseHandler;
    public TexturePackRepository skins;
    public File workingDirectory;
    public static long[] frameTimes = new long[512];
    public static long[] tickTimes = new long[512];
    public static int frameTimePos = 0;
    private String connectToIp;
    private int connectToPort;
    private WaterTexture waterTexture = new WaterTexture();
    private LavaTexture lavaTexture = new LavaTexture();
    private static File workDir = null;
    volatile boolean running = true;
    public String fpsString = "";
    boolean wasDown = false;
    long lastTimer = -1L;
    public boolean mouseGrabbed = false;
    private int lastClickTick = 0;
    public boolean isRaining = false;
    long lastTickTime = System.currentTimeMillis();
    private int recheckPlayerIn = 0;

    public Minecraft(Component component, Canvas canvas, MinecraftApplet minecraftApplet, int n, int n2, boolean bl) {
        this.orgHeight = n2;
        this.fullscreen = bl;
        this.minecraftApplet = minecraftApplet;
        new Thread("Timer hack thread"){
            {
                this.setDaemon(true);
                this.start();
            }

            public void run() {
                while (Minecraft.this.running) {
                    try {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.parent = canvas;
        this.width = n;
        this.height = n2;
        this.fullscreen = bl;
    }

    public abstract void onCrash(CrashReport var1);

    public void connectTo(String string, int n) {
        this.connectToIp = string;
        this.connectToPort = n;
    }

    public void init() throws LWJGLException, IOException {
        if (this.parent != null) {
            Graphics graphics = this.parent.getGraphics();
            if (graphics != null) {
                graphics.setColor(Color.BLACK);
                graphics.fillRect(0, 0, this.width, this.height);
                graphics.dispose();
            }
            Display.setParent((Canvas)this.parent);
        } else if (this.fullscreen) {
            Display.setFullscreen((boolean)true);
            this.width = Display.getDisplayMode().getWidth();
            this.height = Display.getDisplayMode().getHeight();
            if (this.width <= 0) {
                this.width = 1;
            }
            if (this.height <= 0) {
                this.height = 1;
            }
        } else {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.width, this.height));
        }
        Display.setTitle((String)"Minecraft Minecraft Beta 1.2_02");
        try {
            Display.create();
        }
        catch (LWJGLException lWJGLException) {
            lWJGLException.printStackTrace();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Display.create();
        }
        EntityRenderDispatcher.instance.itemInHandRenderer = new ItemInHandRenderer(this);
        this.workingDirectory = Minecraft.getWorkingDirectory();
        this.options = new Options(this, this.workingDirectory);
        this.skins = new TexturePackRepository(this, this.workingDirectory);
        this.textures = new Textures(this.skins, this.options);
        this.font = new Font(this.options, "/font/default.png", this.textures);
        this.renderLoadingScreen();
        Keyboard.create();
        Mouse.create();
        this.mouseHandler = new MouseHandler(this.parent);
        try {
            Controllers.create();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.checkGlError("Pre startup");
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glCullFace((int)1029);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        this.checkGlError("Startup");
        this.openGLCapabilities = new OpenGLCapabilities();
        this.soundEngine.init(this.options);
        this.textures.addDynamicTexture(this.lavaTexture);
        this.textures.addDynamicTexture(this.waterTexture);
        this.textures.addDynamicTexture(new PortalTexture());
        this.textures.addDynamicTexture(new CompassTexture(this));
        this.textures.addDynamicTexture(new ClockTexture(this));
        this.textures.addDynamicTexture(new WaterSideTexture());
        this.textures.addDynamicTexture(new LavaSideTexture());
        this.textures.addDynamicTexture(new FireTexture(0));
        this.textures.addDynamicTexture(new FireTexture(1));
        this.levelRenderer = new LevelRenderer(this, this.textures);
        GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        this.particleEngine = new ParticleEngine(this.level, this.textures);
        try {
            this.bgLoader = new BackgroundDownloader(this.workingDirectory, this);
            this.bgLoader.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkGlError("Post startup");
        this.gui = new Gui(this);
        if (this.connectToIp != null) {
            this.setScreen(new ConnectScreen(this, this.connectToIp, this.connectToPort));
        } else {
            this.setScreen(new TitleScreen());
        }
    }

    private void renderLoadingScreen() throws LWJGLException {
        ScreenSizeCalculator screenSizeCalculator = new ScreenSizeCalculator(this.width, this.height);
        int n = screenSizeCalculator.getWidth();
        int n2 = screenSizeCalculator.getHeight();
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)n, (double)n2, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Tesselator tesselator = Tesselator.instance;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        GL11.glBindTexture((int)3553, (int)this.textures.loadTexture("/title/mojang.png"));
        tesselator.begin();
        tesselator.color(0xFFFFFF);
        tesselator.vertexUV(0.0, this.height, 0.0, 0.0, 0.0);
        tesselator.vertexUV(this.width, this.height, 0.0, 0.0, 0.0);
        tesselator.vertexUV(this.width, 0.0, 0.0, 0.0, 0.0);
        tesselator.vertexUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tesselator.end();
        int n3 = 256;
        int n4 = 256;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tesselator.color(0xFFFFFF);
        this.blit((this.width / 2 - n3) / 2, (this.height / 2 - n4) / 2, 0, 0, n3, n4);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Display.swapBuffers();
    }

    public void blit(int n, int n2, int n3, int n4, int n5, int n6) {
        float f = 0.00390625f;
        float f2 = 0.00390625f;
        Tesselator tesselator = Tesselator.instance;
        tesselator.begin();
        tesselator.vertexUV(n + 0, n2 + n6, 0.0, (float)(n3 + 0) * f, (float)(n4 + n6) * f2);
        tesselator.vertexUV(n + n5, n2 + n6, 0.0, (float)(n3 + n5) * f, (float)(n4 + n6) * f2);
        tesselator.vertexUV(n + n5, n2 + 0, 0.0, (float)(n3 + n5) * f, (float)(n4 + 0) * f2);
        tesselator.vertexUV(n + 0, n2 + 0, 0.0, (float)(n3 + 0) * f, (float)(n4 + 0) * f2);
        tesselator.end();
    }

    public static File getWorkingDirectory() {
        if (workDir == null) {
            workDir = Minecraft.getWorkingDirectory("minecraft");
        }
        return workDir;
    }

    public static File getWorkingDirectory(String string) {
        File file;
        String string2 = System.getProperty("user.home", ".");
        switch (Minecraft.getPlatform()) {
            case linux: 
            case solaris: {
                file = new File(string2, '.' + string + '/');
                break;
            }
            case windows: {
                String string3 = System.getenv("APPDATA");
                if (string3 != null) {
                    file = new File(string3, "." + string + '/');
                    break;
                }
                file = new File(string2, '.' + string + '/');
                break;
            }
            case macos: {
                file = new File(string2, "Library/Application Support/" + string);
                break;
            }
            default: {
                file = new File(string2, string + '/');
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file);
        }
        return file;
    }

    private static OS getPlatform() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("win")) {
            return OS.windows;
        }
        if (string.contains("mac")) {
            return OS.macos;
        }
        if (string.contains("solaris")) {
            return OS.solaris;
        }
        if (string.contains("sunos")) {
            return OS.solaris;
        }
        if (string.contains("linux")) {
            return OS.linux;
        }
        if (string.contains("unix")) {
            return OS.linux;
        }
        return OS.unknown;
    }

    public void setScreen(Screen screen) {
        if (this.screen instanceof ErrorScreen) {
            return;
        }
        if (this.screen != null) {
            this.screen.removed();
        }
        if (screen == null && this.level == null) {
            screen = new TitleScreen();
        } else if (screen == null && this.player.health <= 0) {
            screen = new DeathScreen();
        }
        this.screen = screen;
        if (screen != null) {
            this.releaseMouse();
            ScreenSizeCalculator screenSizeCalculator = new ScreenSizeCalculator(this.width, this.height);
            int n = screenSizeCalculator.getWidth();
            int n2 = screenSizeCalculator.getHeight();
            screen.init(this, n, n2);
            this.noRender = false;
        } else {
            this.grabMouse();
        }
    }

    private void checkGlError(String string) {
        int n = GL11.glGetError();
        if (n != 0) {
            String string2 = GLU.gluErrorString((int)n);
            System.out.println("########## GL ERROR ##########");
            System.out.println("@ " + string);
            System.out.println(n + ": " + string2);
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.minecraftApplet != null) {
            this.minecraftApplet.clearMemory();
        }
        try {
            if (this.bgLoader != null) {
                this.bgLoader.halt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.out.println("Stopping!");
            this.setLevel(null);
            try {
                MemoryTracker.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.soundEngine.destroy();
            Mouse.destroy();
            Keyboard.destroy();
        }
        finally {
            Display.destroy();
        }
        System.gc();
    }

    public void generateFlyby() {
        this.gameMode = new SurvivalMode(this);
        this.selectLevel("flyby");
        this.setScreen(null);
        double d = 0.0;
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(this.width * this.height * 3));
        File file = new File(Minecraft.getWorkingDirectory(), "flyby");
        file.mkdir();
        byte[] byArray = new byte[18];
        byArray[2] = 2;
        byArray[12] = (byte)(this.width % 256);
        byArray[13] = (byte)(this.width / 256);
        byArray[14] = (byte)(this.height % 256);
        byArray[15] = (byte)(this.height / 256);
        byArray[16] = 24;
        byte[] byArray2 = new byte[this.width * this.height * 3];
        int n = 352;
        int n2 = n * 60;
        this.player.yRotO = 12.0f;
        this.player.yRot = 12.0f;
        double d2 = -Math.sin((double)this.player.yRot * Math.PI / 180.0);
        double d3 = Math.cos((double)this.player.yRot * Math.PI / 180.0);
        this.player.xOld = 0.0;
        this.player.xo = 0.0;
        this.player.x = 0.0;
        this.player.zOld = 0.0;
        this.player.zo = 0.0;
        this.player.z = 0.0;
        this.level.time = 0L;
        for (int i = -20; i < n2; ++i) {
            double d4;
            if (i % 100 == 0) {
                System.out.println((double)i * 100.0 / (double)n2 + "%, free: " + (float)(Runtime.getRuntime().freeMemory() / 1024L) / 1024.0f + " MB");
                System.gc();
            }
            double d5 = 0.125 + (double)i / (double)n2 * 5.0;
            AABB.resetPool();
            Vec3.resetPool();
            if (i < 0) {
                this.level.setSpawnSettings(this.options.difficulty > 0, true);
                this.level.tick();
            }
            this.gameRenderer.tick();
            GL11.glEnable((int)3553);
            while (this.level.updateLights()) {
            }
            this.player.xo = this.player.xOld += d2 * d5;
            this.player.x = this.player.xOld;
            this.player.zo = this.player.zOld += d3 * d5;
            this.player.z = this.player.zOld;
            int n3 = 100;
            double d6 = 0.0;
            double d7 = 1.0;
            for (d4 = -4.0; d4 < (double)n3; d4 += d7) {
                for (int j = 0; j < 9; ++j) {
                    double d8 = (double)((float)(j % 3) / 2.0f) - 0.5;
                    double d9 = (double)((float)(j / 3) / 2.0f) - 0.5;
                    double d10 = this.level.getHeightmap(Mth.floor(this.player.x + d2 * d4 + d8), Mth.floor(this.player.z + d3 * d4 + d9));
                    if (!(d10 > d6)) continue;
                    d6 = d10;
                }
            }
            d4 = d6 + 4.0;
            d = d == 0.0 ? d4 : (d += (d4 - d) * d5 / (double)n3 * 4.0);
            this.player.xRot = this.player.xRotO = (float)(d - 64.0) / 2.0f;
            this.player.yo = this.player.yOld = d;
            this.player.y = this.player.yOld;
            this.gameRenderer.renderLevel(1.0f);
            GL11.glBindTexture((int)3553, (int)this.textures.loadTexture("/terrain.png"));
            this.textures.tick();
            Display.update();
            byteBuffer.clear();
            GL11.glReadPixels((int)0, (int)0, (int)this.width, (int)this.height, (int)32992, (int)5121, (ByteBuffer)byteBuffer);
            byteBuffer.clear();
            if (i < 0) continue;
            String string = "" + i;
            while (string.length() < 6) {
                string = "0" + string;
            }
            try {
                byteBuffer.get(byArray2);
                File file2 = new File(file, "img" + string + ".tga");
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file2));
                dataOutputStream.write(byArray);
                dataOutputStream.write(byArray2);
                dataOutputStream.close();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.onCrash(new CrashReport("Failed to start game", exception));
            return;
        }
        try {
            long l = System.currentTimeMillis();
            int n = 0;
            while (this.running && (this.minecraftApplet == null || this.minecraftApplet.isActive())) {
                AABB.resetPool();
                Vec3.resetPool();
                if (this.parent == null && Display.isCloseRequested()) {
                    this.stop();
                }
                if (this.pause && this.level != null) {
                    float f = this.timer.a;
                    this.timer.advanceTime();
                    this.timer.a = f;
                } else {
                    this.timer.advanceTime();
                }
                long l2 = System.nanoTime();
                for (int i = 0; i < this.timer.ticks; ++i) {
                    ++this.ticks;
                    try {
                        this.tick();
                        continue;
                    }
                    catch (LevelConflictException levelConflictException) {
                        this.level = null;
                        this.setLevel(null);
                        this.setScreen(new LevelConflictScreen());
                    }
                }
                long l3 = System.nanoTime() - l2;
                this.checkGlError("Pre render");
                this.soundEngine.update(this.player, this.timer.a);
                GL11.glEnable((int)3553);
                if (this.level != null && !this.level.isOnline) {
                    this.level.updateLights();
                }
                if (this.level != null && this.level.isOnline) {
                    this.level.updateLights();
                }
                if (this.options.limitFramerate) {
                    Thread.sleep(5L);
                }
                if (!Keyboard.isKeyDown((int)65)) {
                    Display.update();
                }
                if (!this.noRender) {
                    if (this.gameMode != null) {
                        this.gameMode.render(this.timer.a);
                    }
                    this.gameRenderer.render(this.timer.a);
                }
                if (!Display.isActive()) {
                    if (this.fullscreen) {
                        this.toggleFullScreen();
                    }
                    Thread.sleep(10L);
                }
                if (Keyboard.isKeyDown((int)61)) {
                    this.renderFpsMeter(l3);
                } else {
                    this.lastTimer = System.nanoTime();
                }
                Thread.yield();
                if (Keyboard.isKeyDown((int)65)) {
                    Display.update();
                }
                this.checkScreenshot();
                if (!(this.parent == null || this.fullscreen || this.parent.getWidth() == this.width && this.parent.getHeight() == this.height)) {
                    this.width = this.parent.getWidth();
                    this.height = this.parent.getHeight();
                    if (this.width <= 0) {
                        this.width = 1;
                    }
                    if (this.height <= 0) {
                        this.height = 1;
                    }
                    this.resize(this.width, this.height);
                }
                this.checkGlError("Post render");
                ++n;
                boolean bl = this.pause = !this.isOnline() && this.screen != null && this.screen.isPauseScreen();
                while (System.currentTimeMillis() >= l + 1000L) {
                    this.fpsString = n + " fps, " + Chunk.updates + " chunk updates";
                    Chunk.updates = 0;
                    l += 1000L;
                    n = 0;
                }
            }
        }
        catch (StopGameException stopGameException) {
        }
        catch (Throwable throwable) {
            this.level = null;
            throwable.printStackTrace();
            this.onCrash(new CrashReport("Unexpected error", throwable));
        }
    }

    private void checkScreenshot() {
        if (Keyboard.isKeyDown((int)60)) {
            if (!this.wasDown) {
                this.wasDown = true;
                if (Keyboard.isKeyDown((int)42)) {
                    this.gui.addMessage(this.grabHugeScreenshot(workDir, this.width, this.height, 36450, 17700));
                } else {
                    this.gui.addMessage(Screenshot.grab(workDir, this.width, this.height));
                }
            }
        } else {
            this.wasDown = false;
        }
    }

    private String grabHugeScreenshot(File file, int n, int n2, int n3, int n4) {
        try {
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(n * n2 * 3));
            Screenshot screenshot = new Screenshot(file, n3, n4, n2);
            double d = (double)n3 / (double)n;
            double d2 = (double)n4 / (double)n2;
            double d3 = d > d2 ? d : d2;
            for (int i = (n4 - 1) / n2 * n2; i >= 0; i -= n2) {
                for (int j = 0; j < n3; j += n) {
                    int n5 = n;
                    int n6 = n2;
                    GL11.glBindTexture((int)3553, (int)this.textures.loadTexture("/terrain.png"));
                    double d4 = (double)(n3 - n) / 2.0 * 2.0 - (double)(j * 2);
                    double d5 = (double)(n4 - n2) / 2.0 * 2.0 - (double)(i * 2);
                    this.gameRenderer.zoomRegion(d3, d4 /= (double)n, d5 /= (double)n2);
                    this.gameRenderer.renderLevel(1.0f);
                    this.gameRenderer.unZoomRegion();
                    Display.update();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    Display.update();
                    byteBuffer.clear();
                    GL11.glPixelStorei((int)3333, (int)1);
                    GL11.glPixelStorei((int)3317, (int)1);
                    GL11.glReadPixels((int)0, (int)0, (int)n5, (int)n6, (int)32992, (int)5121, (ByteBuffer)byteBuffer);
                    screenshot.addRegion(byteBuffer, j, i, n5, n6);
                }
                screenshot.saveRow();
            }
            return screenshot.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Failed to save image: " + exception;
        }
    }

    private void renderFpsMeter(long l) {
        int n;
        long l2 = 16666666L;
        if (this.lastTimer == -1L) {
            this.lastTimer = System.nanoTime();
        }
        long l3 = System.nanoTime();
        Minecraft.tickTimes[Minecraft.frameTimePos & Minecraft.frameTimes.length - 1] = l;
        Minecraft.frameTimes[Minecraft.frameTimePos++ & Minecraft.frameTimes.length - 1] = l3 - this.lastTimer;
        this.lastTimer = l3;
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)3553);
        Tesselator tesselator = Tesselator.instance;
        tesselator.begin(7);
        int n2 = (int)(l2 / 200000L);
        tesselator.color(0x20000000);
        tesselator.vertex(0.0, this.height - n2, 0.0);
        tesselator.vertex(0.0, this.height, 0.0);
        tesselator.vertex(frameTimes.length, this.height, 0.0);
        tesselator.vertex(frameTimes.length, this.height - n2, 0.0);
        tesselator.color(0x20200000);
        tesselator.vertex(0.0, this.height - n2 * 2, 0.0);
        tesselator.vertex(0.0, this.height - n2, 0.0);
        tesselator.vertex(frameTimes.length, this.height - n2, 0.0);
        tesselator.vertex(frameTimes.length, this.height - n2 * 2, 0.0);
        tesselator.end();
        long l4 = 0L;
        for (n = 0; n < frameTimes.length; ++n) {
            l4 += frameTimes[n];
        }
        n = (int)(l4 / 200000L / (long)frameTimes.length);
        tesselator.begin(7);
        tesselator.color(0x20400000);
        tesselator.vertex(0.0, this.height - n, 0.0);
        tesselator.vertex(0.0, this.height, 0.0);
        tesselator.vertex(frameTimes.length, this.height, 0.0);
        tesselator.vertex(frameTimes.length, this.height - n, 0.0);
        tesselator.end();
        tesselator.begin(1);
        for (int i = 0; i < frameTimes.length; ++i) {
            int n3 = (i - frameTimePos & frameTimes.length - 1) * 255 / frameTimes.length;
            int n4 = n3 * n3 / 255;
            n4 = n4 * n4 / 255;
            int n5 = n4 * n4 / 255;
            n5 = n5 * n5 / 255;
            if (frameTimes[i] > l2) {
                tesselator.color(-16777216 + n4 * 65536);
            } else {
                tesselator.color(-16777216 + n4 * 256);
            }
            long l5 = frameTimes[i] / 200000L;
            long l6 = tickTimes[i] / 200000L;
            tesselator.vertex((float)i + 0.5f, (float)((long)this.height - l5) + 0.5f, 0.0);
            tesselator.vertex((float)i + 0.5f, (float)this.height + 0.5f, 0.0);
            tesselator.color(-16777216 + n4 * 65536 + n4 * 256 + n4 * 1);
            tesselator.vertex((float)i + 0.5f, (float)((long)this.height - l5) + 0.5f, 0.0);
            tesselator.vertex((float)i + 0.5f, (float)((long)this.height - (l5 - l6)) + 0.5f, 0.0);
        }
        tesselator.end();
        GL11.glEnable((int)3553);
    }

    public void stop() {
        this.running = false;
    }

    public void grabMouse() {
        if (!Display.isActive()) {
            return;
        }
        if (this.mouseGrabbed) {
            return;
        }
        this.mouseGrabbed = true;
        this.mouseHandler.grab();
        this.setScreen(null);
        this.lastClickTick = this.ticks + 10000;
    }

    public void releaseMouse() {
        if (!this.mouseGrabbed) {
            return;
        }
        if (this.player != null) {
            this.player.releaseAllKeys();
        }
        this.mouseGrabbed = false;
        this.mouseHandler.release();
    }

    public void pauseGame() {
        if (this.screen != null) {
            return;
        }
        this.setScreen(new PauseScreen());
    }

    private void handleMouseDown(int n, boolean bl) {
        if (this.gameMode.instaBuild) {
            return;
        }
        if (n == 0 && this.missTime > 0) {
            return;
        }
        if (bl && this.hitResult != null && this.hitResult.type == HitResult.Type.TILE && n == 0) {
            int n2 = this.hitResult.x;
            int n3 = this.hitResult.y;
            int n4 = this.hitResult.z;
            this.gameMode.continueDestroyBlock(n2, n3, n4, this.hitResult.f);
            this.particleEngine.crack(n2, n3, n4, this.hitResult.f);
        } else {
            this.gameMode.stopDestroyBlock();
        }
    }

    private void handleMouseClick(int n) {
        ItemInstance itemInstance;
        if (n == 0 && this.missTime > 0) {
            return;
        }
        if (n == 0) {
            this.player.swing();
        }
        boolean bl = true;
        if (this.hitResult == null) {
            if (n == 0 && !(this.gameMode instanceof CreativeMode)) {
                this.missTime = 10;
            }
        } else if (this.hitResult.type == HitResult.Type.ENTITY) {
            if (n == 0) {
                this.gameMode.attack(this.player, this.hitResult.entity);
            }
            if (n == 1) {
                this.gameMode.interact(this.player, this.hitResult.entity);
            }
        } else if (this.hitResult.type == HitResult.Type.TILE) {
            int n2 = this.hitResult.x;
            int n3 = this.hitResult.y;
            int n4 = this.hitResult.z;
            int n5 = this.hitResult.f;
            Tile tile = Tile.tiles[this.level.getTile(n2, n3, n4)];
            if (n == 0) {
                this.level.extinguishFire(n2, n3, n4, this.hitResult.f);
                if (tile != Tile.unbreakable || this.player.userType >= 100) {
                    this.gameMode.startDestroyBlock(n2, n3, n4, this.hitResult.f);
                }
            } else {
                int n6;
                ItemInstance itemInstance2 = this.player.inventory.getSelected();
                int n7 = n6 = itemInstance2 != null ? itemInstance2.count : 0;
                if (this.gameMode.useItemOn(this.player, this.level, itemInstance2, n2, n3, n4, n5)) {
                    bl = false;
                    this.player.swing();
                }
                if (itemInstance2 == null) {
                    return;
                }
                if (itemInstance2.count == 0) {
                    this.player.inventory.items[this.player.inventory.selected] = null;
                } else if (itemInstance2.count != n6) {
                    this.gameRenderer.itemInHandRenderer.itemPlaced();
                }
            }
        }
        if (bl && n == 1 && (itemInstance = this.player.inventory.getSelected()) != null && this.gameMode.useItem(this.player, this.level, itemInstance)) {
            this.gameRenderer.itemInHandRenderer.itemUsed();
        }
    }

    public void toggleFullScreen() {
        try {
            this.fullscreen = !this.fullscreen;
            System.out.println("Toggle fullscreen!");
            if (this.fullscreen) {
                Display.setDisplayMode((DisplayMode)Display.getDesktopDisplayMode());
                this.width = Display.getDisplayMode().getWidth();
                this.height = Display.getDisplayMode().getHeight();
                if (this.width <= 0) {
                    this.width = 1;
                }
                if (this.height <= 0) {
                    this.height = 1;
                }
            } else {
                if (this.parent != null) {
                    this.width = this.parent.getWidth();
                    this.height = this.parent.getHeight();
                } else {
                    this.width = this.orgWidth;
                    this.height = this.orgHeight;
                }
                if (this.width <= 0) {
                    this.width = 1;
                }
                if (this.height <= 0) {
                    this.height = 1;
                }
                Display.setDisplayMode((DisplayMode)new DisplayMode(this.orgWidth, this.orgHeight));
            }
            this.releaseMouse();
            Display.setFullscreen((boolean)this.fullscreen);
            Display.update();
            Thread.sleep(1000L);
            if (this.fullscreen) {
                this.grabMouse();
            }
            if (this.screen != null) {
                this.releaseMouse();
                this.resize(this.width, this.height);
            }
            System.out.println("Size: " + this.width + ", " + this.height);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void resize(int n, int n2) {
        if (n <= 0) {
            n = 1;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        this.width = n;
        this.height = n2;
        if (this.screen != null) {
            ScreenSizeCalculator screenSizeCalculator = new ScreenSizeCalculator(n, n2);
            int n3 = screenSizeCalculator.getWidth();
            int n4 = screenSizeCalculator.getHeight();
            this.screen.init(this, n3, n4);
        }
    }

    private void handleGrabTexture() {
        if (this.hitResult != null) {
            int n = this.level.getTile(this.hitResult.x, this.hitResult.y, this.hitResult.z);
            if (n == Tile.grass.id) {
                n = Tile.dirt.id;
            }
            if (n == Tile.stoneSlab.id) {
                n = Tile.stoneSlabHalf.id;
            }
            if (n == Tile.unbreakable.id) {
                n = Tile.rock.id;
            }
            this.player.inventory.grabTexture(n, this.gameMode instanceof CreativeMode);
        }
    }

    public void tick() {
        int n;
        this.gui.tick();
        this.gameRenderer.pick(1.0f);
        if (this.player != null) {
            this.player.prepareForTick();
            ChunkSource chunkSource = this.level.getChunkSource();
            if (chunkSource instanceof ChunkCache) {
                ChunkCache chunkCache = (ChunkCache)chunkSource;
                n = Mth.floor((int)this.player.x) >> 4;
                int n2 = Mth.floor((int)this.player.z) >> 4;
                chunkCache.centerOn(n, n2);
            }
        }
        if (!this.pause && this.level != null) {
            this.gameMode.tick();
        }
        GL11.glBindTexture((int)3553, (int)this.textures.loadTexture("/terrain.png"));
        if (!this.pause) {
            this.textures.tick();
        }
        if (this.screen == null && this.player != null && this.player.health <= 0) {
            this.setScreen(null);
        }
        if (this.screen != null) {
            this.lastClickTick = this.ticks + 10000;
        }
        if (this.screen != null) {
            this.screen.updateEvents();
            if (this.screen != null) {
                this.screen.tick();
            }
        }
        if (this.screen == null || this.screen.passEvents) {
            while (Mouse.next()) {
                long l = System.currentTimeMillis() - this.lastTickTime;
                if (l > 200L) continue;
                n = Mouse.getEventDWheel();
                if (n != 0) {
                    this.player.inventory.swapPaint(n);
                }
                if (this.screen == null) {
                    if (!this.mouseGrabbed && Mouse.getEventButtonState()) {
                        this.grabMouse();
                        continue;
                    }
                    if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState()) {
                        this.handleMouseClick(0);
                        this.lastClickTick = this.ticks;
                    }
                    if (Mouse.getEventButton() == 1 && Mouse.getEventButtonState()) {
                        this.handleMouseClick(1);
                        this.lastClickTick = this.ticks;
                    }
                    if (Mouse.getEventButton() != 2 || !Mouse.getEventButtonState()) continue;
                    this.handleGrabTexture();
                    continue;
                }
                if (this.screen == null) continue;
                this.screen.mouseEvent();
            }
            if (this.missTime > 0) {
                --this.missTime;
            }
            while (Keyboard.next()) {
                this.player.setKey(Keyboard.getEventKey(), Keyboard.getEventKeyState());
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == 87) {
                    this.toggleFullScreen();
                    continue;
                }
                if (this.screen != null) {
                    this.screen.keyboardEvent();
                } else {
                    if (Keyboard.getEventKey() == 1) {
                        this.pauseGame();
                    }
                    if (Keyboard.getEventKey() == 31 && Keyboard.isKeyDown((int)61)) {
                        this.reloadSound();
                    }
                    if (Keyboard.getEventKey() == 63) {
                        this.options.thirdPersonView = !this.options.thirdPersonView;
                    }
                }
                for (int i = 0; i < 9; ++i) {
                    if (Keyboard.getEventKey() != 2 + i) continue;
                    this.player.inventory.selected = i;
                }
                if (Keyboard.getEventKey() != this.options.keyFog.key) continue;
                this.options.toggle(Options.Option.RENDER_DISTANCE, Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? -1 : 1);
            }
            if (this.screen == null) {
                if (Mouse.isButtonDown((int)0) && (float)(this.ticks - this.lastClickTick) >= this.timer.ticksPerSecond / 4.0f && this.mouseGrabbed) {
                    this.handleMouseClick(0);
                    this.lastClickTick = this.ticks;
                }
                if (Mouse.isButtonDown((int)1) && (float)(this.ticks - this.lastClickTick) >= this.timer.ticksPerSecond / 4.0f && this.mouseGrabbed) {
                    this.handleMouseClick(1);
                    this.lastClickTick = this.ticks;
                }
            }
            this.handleMouseDown(0, this.screen == null && Mouse.isButtonDown((int)0) && this.mouseGrabbed);
        }
        if (this.level != null) {
            if (this.player != null) {
                ++this.recheckPlayerIn;
                if (this.recheckPlayerIn == 30) {
                    this.recheckPlayerIn = 0;
                    this.level.ensureAdded(this.player);
                }
            }
            this.level.difficulty = this.options.difficulty;
            if (this.level.isOnline) {
                this.level.difficulty = 3;
            }
            if (!this.pause) {
                this.gameRenderer.tick();
            }
            if (!this.pause) {
                this.levelRenderer.tick();
            }
            if (!this.pause) {
                this.level.tickEntities();
            }
            if (!this.pause || this.isOnline()) {
                this.level.setSpawnSettings(this.options.difficulty > 0, true);
                this.level.tick();
            }
            if (!this.pause && this.level != null) {
                this.level.animateTick(Mth.floor(this.player.x), Mth.floor(this.player.y), Mth.floor(this.player.z));
            }
            if (!this.pause) {
                this.particleEngine.tick();
            }
        }
        this.lastTickTime = System.currentTimeMillis();
    }

    private void reloadSound() {
        System.out.println("FORCING RELOAD!");
        this.soundEngine = new SoundEngine();
        this.soundEngine.init(this.options);
        this.bgLoader.forceReload();
    }

    public boolean isOnline() {
        return this.level != null && this.level.isOnline;
    }

    public static void checkError() {
    }

    public void selectLevel(String string) {
        this.setLevel(null);
        System.gc();
        Level level = new Level(new File(Minecraft.getWorkingDirectory(), "saves"), string);
        if (level.isNew) {
            this.setLevel(level, "Generating level");
        } else {
            this.setLevel(level, "Loading level");
        }
    }

    public void toggleDimension() {
        this.player.dimension = this.player.dimension == -1 ? 0 : -1;
        this.level.removeEntity(this.player);
        this.player.removed = false;
        double d = this.player.x;
        double d2 = this.player.z;
        double d3 = 8.0;
        if (this.player.dimension == -1) {
            this.player.moveTo(d /= d3, this.player.y, d2 /= d3, this.player.yRot, this.player.xRot);
            this.level.tick(this.player, false);
            Level level = new Level(this.level, new HellDimension());
            this.setLevel(level, "Entering the Nether", this.player);
        } else {
            this.player.moveTo(d *= d3, this.player.y, d2 *= d3, this.player.yRot, this.player.xRot);
            this.level.tick(this.player, false);
            Level level = new Level(this.level, new Dimension());
            this.setLevel(level, "Leaving the Nether", this.player);
        }
        this.player.level = this.level;
        this.player.moveTo(d, this.player.y, d2, this.player.yRot, this.player.xRot);
        this.level.tick(this.player, false);
        new PortalForcer().force(this.level, this.player);
    }

    public boolean saveSlot(int n, String string) {
        return false;
    }

    public boolean loadSlot(String string, int n) {
        return false;
    }

    public void setLevel(Level level) {
        this.setLevel(level, "");
    }

    public void setLevel(Level level, String string) {
        this.setLevel(level, string, null);
    }

    public void setLevel(Level level, String string, Player player) {
        this.progressRenderer.progressStart(string);
        this.progressRenderer.progressStage("");
        this.soundEngine.playStreaming(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.level != null) {
            this.level.forceSave(this.progressRenderer);
        }
        this.level = level;
        System.out.println("Player is " + this.player);
        if (level != null) {
            ChunkSource chunkSource;
            this.gameMode.initLevel(level);
            if (!this.isOnline()) {
                if (player == null) {
                    this.player = (LocalPlayer)level.findSubclassOf(LocalPlayer.class);
                }
            } else if (this.player != null) {
                this.player.resetPos();
                if (level != null) {
                    level.addEntity(this.player);
                }
            }
            if (!level.isOnline) {
                this.prepareLevel(string);
            }
            System.out.println("Player is now " + this.player);
            if (this.player == null) {
                this.player = (LocalPlayer)this.gameMode.createPlayer(level);
                this.player.resetPos();
                this.gameMode.initPlayer(this.player);
            }
            this.player.input = new KeyboardInput(this.options);
            if (this.levelRenderer != null) {
                this.levelRenderer.setLevel(level);
            }
            if (this.particleEngine != null) {
                this.particleEngine.setLevel(level);
            }
            this.gameMode.adjustPlayer(this.player);
            if (player != null) {
                level.clearLoadedPlayerData();
            }
            if ((chunkSource = level.getChunkSource()) instanceof ChunkCache) {
                ChunkCache chunkCache = (ChunkCache)chunkSource;
                int n = Mth.floor((int)this.player.x) >> 4;
                int n2 = Mth.floor((int)this.player.z) >> 4;
                chunkCache.centerOn(n, n2);
            }
            level.loadPlayer(this.player);
            if (level.isNew) {
                level.forceSave(this.progressRenderer);
            }
        } else {
            this.player = null;
        }
        System.gc();
        this.lastTickTime = 0L;
    }

    private void prepareLevel(String string) {
        this.progressRenderer.progressStart(string);
        this.progressRenderer.progressStage("Building terrain");
        int n = 128;
        int n2 = 0;
        int n3 = n * 2 / 16 + 1;
        n3 *= n3;
        ChunkSource chunkSource = this.level.getChunkSource();
        int n4 = this.level.xSpawn;
        int n5 = this.level.zSpawn;
        if (this.player != null) {
            n4 = (int)this.player.x;
            n5 = (int)this.player.z;
        }
        if (chunkSource instanceof ChunkCache) {
            ChunkCache chunkCache = (ChunkCache)chunkSource;
            chunkCache.centerOn(n4 >> 4, n5 >> 4);
        }
        for (int i = -n; i <= n; i += 16) {
            for (int j = -n; j <= n; j += 16) {
                this.progressRenderer.progressStagePercentage(n2++ * 100 / n3);
                this.level.getTile(n4 + i, 64, n5 + j);
                while (this.level.updateLights()) {
                }
            }
        }
        this.progressRenderer.progressStage("Simulating world for a bit");
        n3 = 2000;
        this.level.prepare();
    }

    public void playSound(String string, Entity entity, float f, float f2) {
    }

    public void playSound(String string, float f, float f2, float f3, float f4, float f5) {
    }

    public void fileDownloaded(String string, File file) {
        int n = string.indexOf("/");
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        if (string2.equalsIgnoreCase("sound")) {
            this.soundEngine.add(string, file);
        } else if (string2.equalsIgnoreCase("newsound")) {
            this.soundEngine.add(string, file);
        } else if (string2.equalsIgnoreCase("streaming")) {
            this.soundEngine.addStreaming(string, file);
        } else if (string2.equalsIgnoreCase("music")) {
            this.soundEngine.addMusic(string, file);
        } else if (string2.equalsIgnoreCase("newmusic")) {
            this.soundEngine.addMusic(string, file);
        }
    }

    public OpenGLCapabilities getOpenGLCapabilities() {
        return this.openGLCapabilities;
    }

    public String gatherStats1() {
        return this.levelRenderer.gatherStats1();
    }

    public String gatherStats2() {
        return this.levelRenderer.gatherStats2();
    }

    public String gatherStats4() {
        return this.level.gatherChunkSourceStats();
    }

    public String gatherStats3() {
        return "P: " + this.particleEngine.countParticles() + ". T: " + this.level.gatherStats();
    }

    public void respawnPlayer() {
        if (!this.level.dimension.mayRespawn()) {
            this.toggleDimension();
        }
        int n = this.level.xSpawn;
        int n2 = this.level.zSpawn;
        ChunkSource chunkSource = this.level.getChunkSource();
        if (chunkSource instanceof ChunkCache) {
            ChunkCache chunkCache = (ChunkCache)chunkSource;
            chunkCache.centerOn(n >> 4, n2 >> 4);
        }
        this.level.validateSpawn();
        this.level.removeAllPendingEntityRemovals();
        int n3 = 0;
        if (this.player != null) {
            n3 = this.player.entityId;
            this.level.removeEntity(this.player);
        }
        this.player = (LocalPlayer)this.gameMode.createPlayer(this.level);
        this.player.resetPos();
        this.gameMode.initPlayer(this.player);
        this.level.loadPlayer(this.player);
        this.player.input = new KeyboardInput(this.options);
        this.player.entityId = n3;
        this.gameMode.adjustPlayer(this.player);
        this.prepareLevel("Respawning");
        if (this.screen instanceof DeathScreen) {
            this.setScreen(null);
        }
    }

    public static void start(String string, String string2) throws LWJGLException {
        Minecraft.startAndConnectTo(string, string2, null);
    }

    public static void startAndConnectTo(String string, String string2, String string3) {
        boolean bl = false;
        String string4 = string;
        final Frame frame = new Frame("Minecraft");
        Canvas canvas = new Canvas();
        frame.setLayout(new BorderLayout());
        frame.add((Component)canvas, "Center");
        canvas.setPreferredSize(new java.awt.Dimension(854, 480));
        frame.pack();
        frame.setLocationRelativeTo(null);
        final Minecraft minecraft = new Minecraft(frame, canvas, null, 854, 480, bl){

            public void onCrash(CrashReport crashReport) {
                frame.removeAll();
                frame.add((Component)new CrashInfoPanel(crashReport), "Center");
                frame.validate();
            }
        };
        final Thread thread = new Thread((Runnable)minecraft, "Minecraft main thread");
        thread.setPriority(10);
        minecraft.serverDomain = "www.minecraft.net";
        minecraft.user = string4 != null && string2 != null ? new User(string4, string2) : new User("Player" + System.currentTimeMillis() % 1000L, "");
        if (string3 != null) {
            String[] stringArray = string3.split(":");
            minecraft.connectTo(stringArray[0], Integer.parseInt(stringArray[1]));
        }
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                minecraft.stop();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                System.exit(0);
            }
        });
        thread.start();
    }

    public ClientConnection getConnection() {
        if (this.player instanceof MultiplayerLocalPlayer) {
            return ((MultiplayerLocalPlayer)this.player).connection;
        }
        return null;
    }

    public static void main(String[] stringArray) throws LWJGLException {
        String string = "Player" + System.currentTimeMillis() % 1000L;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        String string2 = "-";
        if (stringArray.length > 1) {
            string2 = stringArray[1];
        }
        Minecraft.start(string, string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OS {
        linux,
        solaris,
        windows,
        macos,
        unknown;

    }
}

