/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class MemoryTracker {
    private static List<Integer> lists = new ArrayList<Integer>();
    private static List<Integer> textures = new ArrayList<Integer>();

    public static synchronized int genLists(int count) {
        int id = GL11.glGenLists((int)count);
        lists.add(id);
        lists.add(count);
        return id;
    }

    public static synchronized void genTextures(IntBuffer ib) {
        GL11.glGenTextures((IntBuffer)ib);
        int i = ib.position();
        while (i < ib.limit()) {
            textures.add(ib.get(i));
            ++i;
        }
    }

    public static synchronized void release() {
        int i = 0;
        while (i < lists.size()) {
            GL11.glDeleteLists((int)lists.get(i), (int)lists.get(i + 1));
            i += 2;
        }
        IntBuffer ib = MemoryTracker.createIntBuffer(textures.size());
        ib.flip();
        GL11.glDeleteTextures((IntBuffer)ib);
        int i2 = 0;
        while (i2 < textures.size()) {
            ib.put(textures.get(i2));
            ++i2;
        }
        ib.flip();
        GL11.glDeleteTextures((IntBuffer)ib);
        lists.clear();
        textures.clear();
    }

    public static synchronized ByteBuffer createByteBuffer(int size) {
        ByteBuffer bb = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        return bb;
    }

    public static ShortBuffer createShortBuffer(int size) {
        return MemoryTracker.createByteBuffer(size << 1).asShortBuffer();
    }

    public static CharBuffer createCharBuffer(int size) {
        return MemoryTracker.createByteBuffer(size << 1).asCharBuffer();
    }

    public static IntBuffer createIntBuffer(int size) {
        return MemoryTracker.createByteBuffer(size << 2).asIntBuffer();
    }

    public static LongBuffer createLongBuffer(int size) {
        return MemoryTracker.createByteBuffer(size << 3).asLongBuffer();
    }

    public static FloatBuffer createFloatBuffer(int size) {
        return MemoryTracker.createByteBuffer(size << 2).asFloatBuffer();
    }

    public static DoubleBuffer createDoubleBuffer(int size) {
        return MemoryTracker.createByteBuffer(size << 3).asDoubleBuffer();
    }
}

