/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import net.minecraft.client.CrashReport;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;

public class CrashInfoPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public CrashInfoPanel(CrashReport report) {
        this.setBackground(new Color(3028036));
        this.setLayout(new BorderLayout());
        StringWriter sw = new StringWriter();
        report.e.printStackTrace(new PrintWriter(sw));
        String stacktrace = sw.toString();
        String vendor = "";
        String msg = "";
        try {
            msg = String.valueOf(msg) + "Generated " + new SimpleDateFormat().format(new Date()) + "\n";
            msg = String.valueOf(msg) + "\n";
            msg = String.valueOf(msg) + "Minecraft: Minecraft Beta 1.2_02\n";
            msg = String.valueOf(msg) + "OS: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version") + "\n";
            msg = String.valueOf(msg) + "Java: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor") + "\n";
            msg = String.valueOf(msg) + "VM: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor") + "\n";
            msg = String.valueOf(msg) + "LWJGL: " + Sys.getVersion() + "\n";
            vendor = GL11.glGetString((int)7936);
            msg = String.valueOf(msg) + "OpenGL: " + GL11.glGetString((int)7937) + " version " + GL11.glGetString((int)7938) + ", " + GL11.glGetString((int)7936) + "\n";
        }
        catch (Throwable e) {
            msg = String.valueOf(msg) + "[failed to get system properties (" + e + ")]\n";
        }
        msg = String.valueOf(msg) + "\n";
        msg = String.valueOf(msg) + stacktrace;
        String text = "";
        text = String.valueOf(text) + "\n";
        text = String.valueOf(text) + "\n";
        if (stacktrace.contains("Pixel format not accelerated")) {
            text = String.valueOf(text) + "      Bad video card drivers!      \n";
            text = String.valueOf(text) + "      -----------------------      \n";
            text = String.valueOf(text) + "\n";
            text = String.valueOf(text) + "Minecraft was unable to start because it failed to find an accelerated OpenGL mode.\n";
            text = String.valueOf(text) + "This can usually be fixed by updating the video card drivers.\n";
            if (vendor.toLowerCase().contains("nvidia")) {
                text = String.valueOf(text) + "\n";
                text = String.valueOf(text) + "You might be able to find drivers for your video card here:\n";
                text = String.valueOf(text) + "  http://www.nvidia.com/\n";
            } else if (vendor.toLowerCase().contains("ati")) {
                text = String.valueOf(text) + "\n";
                text = String.valueOf(text) + "You might be able to find drivers for your video card here:\n";
                text = String.valueOf(text) + "  http://www.amd.com/\n";
            }
        } else {
            text = String.valueOf(text) + "      Minecraft has crashed!      \n";
            text = String.valueOf(text) + "      ----------------------      \n";
            text = String.valueOf(text) + "\n";
            text = String.valueOf(text) + "Minecraft has stopped running because it encountered a problem.\n";
            text = String.valueOf(text) + "\n";
            text = String.valueOf(text) + "If you wish to report this, please copy this entire text and email it to support@mojang.com.\n";
            text = String.valueOf(text) + "Please include a description of what you did when the error occured.\n";
        }
        text = String.valueOf(text) + "\n";
        text = String.valueOf(text) + "\n";
        text = String.valueOf(text) + "\n";
        text = String.valueOf(text) + "--- BEGIN ERROR REPORT " + Integer.toHexString(text.hashCode()) + " --------\n";
        text = String.valueOf(text) + msg;
        text = String.valueOf(text) + "--- END ERROR REPORT " + Integer.toHexString(text.hashCode()) + " ----------\n";
        text = String.valueOf(text) + "\n";
        text = String.valueOf(text) + "\n";
        TextArea textArea = new TextArea(text, 0, 0, 1);
        textArea.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)new LogoBorder(), "North");
        this.add((Component)new Border(80), "East");
        this.add((Component)new Border(80), "West");
        this.add((Component)new Border(100), "South");
        this.add((Component)textArea, "Center");
    }

    private static class Border
    extends Canvas {
        private static final long serialVersionUID = 1L;

        public Border(int size) {
            this.setPreferredSize(new Dimension(size, size));
            this.setMinimumSize(new Dimension(size, size));
        }
    }

    private static class LogoBorder
    extends Canvas {
        private static final long serialVersionUID = 1L;
        private BufferedImage image;

        public LogoBorder() {
            try {
                this.image = ImageIO.read(CrashInfoPanel.class.getResource("/gui/logo.png"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int size = 100;
            this.setPreferredSize(new Dimension(size, size));
            this.setMinimumSize(new Dimension(size, size));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.drawImage(this.image, this.getWidth() / 2 - this.image.getWidth() / 2, 32, null);
        }
    }
}

