/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pos
implements Comparable<Pos> {
    public int x;
    public int y;
    public int z;

    public Pos() {
    }

    public Pos(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pos)) {
            return false;
        }
        Pos pos = (Pos)object;
        return this.x == pos.x && this.y == pos.y && this.z == pos.z;
    }

    public int hashCode() {
        return this.x + this.z << 8 + this.y << 16;
    }

    @Override
    public int compareTo(Pos pos) {
        if (this.y == pos.y) {
            if (this.z == pos.z) {
                return this.x - pos.x;
            }
            return this.z - pos.z;
        }
        return this.y - pos.y;
    }

    public Pos offset(int n, int n2, int n3) {
        return new Pos(this.x + n, this.y + n2, this.z + n3);
    }

    public void set(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public void set(Pos pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public Pos above() {
        return new Pos(this.x, this.y + 1, this.z);
    }

    public Pos above(int n) {
        return new Pos(this.x, this.y + n, this.z);
    }

    public Pos below() {
        return new Pos(this.x, this.y - 1, this.z);
    }

    public Pos below(int n) {
        return new Pos(this.x, this.y - n, this.z);
    }

    public Pos north() {
        return new Pos(this.x, this.y, this.z - 1);
    }

    public Pos north(int n) {
        return new Pos(this.x, this.y, this.z - n);
    }

    public Pos south() {
        return new Pos(this.x, this.y, this.z + 1);
    }

    public Pos south(int n) {
        return new Pos(this.x, this.y, this.z + n);
    }

    public Pos west() {
        return new Pos(this.x - 1, this.y, this.z);
    }

    public Pos west(int n) {
        return new Pos(this.x - 1, this.y, this.z);
    }

    public Pos east() {
        return new Pos(this.x + 1, this.y, this.z);
    }

    public Pos east(int n) {
        return new Pos(this.x + n, this.y, this.z);
    }

    public void move(int n, int n2, int n3) {
        this.x += n;
        this.y += n2;
        this.z += n3;
    }

    public void move(Pos pos) {
        this.x += pos.x;
        this.y += pos.y;
        this.z += pos.z;
    }

    public void moveX(int n) {
        this.x += n;
    }

    public void moveY(int n) {
        this.y += n;
    }

    public void moveZ(int n) {
        this.z += n;
    }

    public void moveUp(int n) {
        this.y += n;
    }

    public void moveUp() {
        ++this.y;
    }

    public void moveDown(int n) {
        this.y -= n;
    }

    public void moveDown() {
        --this.y;
    }

    public void moveEast(int n) {
        this.x += n;
    }

    public void moveEast() {
        ++this.x;
    }

    public void moveWest(int n) {
        this.x -= n;
    }

    public void moveWest() {
        --this.x;
    }

    public void moveNorth(int n) {
        this.z -= n;
    }

    public void moveNorth() {
        --this.z;
    }

    public void moveSouth(int n) {
        this.z += n;
    }

    public void moveSouth() {
        ++this.z;
    }
}

