/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt;

import com.mojang.nbt.ByteArrayTag;
import com.mojang.nbt.ByteTag;
import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.DoubleTag;
import com.mojang.nbt.EndTag;
import com.mojang.nbt.FloatTag;
import com.mojang.nbt.IntTag;
import com.mojang.nbt.ListTag;
import com.mojang.nbt.LongTag;
import com.mojang.nbt.ShortTag;
import com.mojang.nbt.StringTag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;

public abstract class Tag {
    public static final byte TAG_End = 0;
    public static final byte TAG_Byte = 1;
    public static final byte TAG_Short = 2;
    public static final byte TAG_Int = 3;
    public static final byte TAG_Long = 4;
    public static final byte TAG_Float = 5;
    public static final byte TAG_Double = 6;
    public static final byte TAG_Byte_Array = 7;
    public static final byte TAG_String = 8;
    public static final byte TAG_List = 9;
    public static final byte TAG_Compound = 10;
    private String name = null;

    abstract void write(DataOutput var1) throws IOException;

    abstract void load(DataInput var1) throws IOException;

    public abstract String toString();

    public abstract byte getId();

    public void print(PrintStream printStream) {
        this.print("", printStream);
    }

    public void print(String string, PrintStream printStream) {
        String string2 = this.getName();
        printStream.print(string);
        printStream.print(Tag.getTagName(this.getId()));
        if (string2.length() > 0) {
            printStream.print("(\"" + string2 + "\")");
        }
        printStream.print(": ");
        printStream.println(this.toString());
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public Tag setName(String string) {
        this.name = string;
        return this;
    }

    public static Tag readNamedTag(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        if (by == 0) {
            return new EndTag();
        }
        Tag tag = Tag.newTag(by);
        tag.name = dataInput.readUTF();
        tag.load(dataInput);
        return tag;
    }

    public static void writeNamedTag(Tag tag, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(tag.getId());
        if (tag.getId() == 0) {
            return;
        }
        dataOutput.writeUTF(tag.getName());
        tag.write(dataOutput);
    }

    public static Tag newTag(byte by) {
        switch (by) {
            case 0: {
                return new EndTag();
            }
            case 1: {
                return new ByteTag();
            }
            case 2: {
                return new ShortTag();
            }
            case 3: {
                return new IntTag();
            }
            case 4: {
                return new LongTag();
            }
            case 5: {
                return new FloatTag();
            }
            case 6: {
                return new DoubleTag();
            }
            case 7: {
                return new ByteArrayTag();
            }
            case 8: {
                return new StringTag();
            }
            case 9: {
                return new ListTag();
            }
            case 10: {
                return new CompoundTag();
            }
        }
        return null;
    }

    public static String getTagName(byte by) {
        switch (by) {
            case 0: {
                return "TAG_End";
            }
            case 1: {
                return "TAG_Byte";
            }
            case 2: {
                return "TAG_Short";
            }
            case 3: {
                return "TAG_Int";
            }
            case 4: {
                return "TAG_Long";
            }
            case 5: {
                return "TAG_Float";
            }
            case 6: {
                return "TAG_Double";
            }
            case 7: {
                return "TAG_Byte_Array";
            }
            case 8: {
                return "TAG_String";
            }
            case 9: {
                return "TAG_List";
            }
            case 10: {
                return "TAG_Compound";
            }
        }
        return "UNKNOWN";
    }
}

