/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt;

import com.mojang.nbt.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTag<T extends Tag>
extends Tag {
    private List<T> list = new ArrayList<T>();
    private byte type;

    @Override
    void write(DataOutput dataOutput) throws IOException {
        this.type = this.list.size() > 0 ? ((Tag)this.list.get(0)).getId() : (byte)1;
        dataOutput.writeByte(this.type);
        dataOutput.writeInt(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            ((Tag)this.list.get(i)).write(dataOutput);
        }
    }

    @Override
    void load(DataInput dataInput) throws IOException {
        this.type = dataInput.readByte();
        int n = dataInput.readInt();
        this.list = new ArrayList<T>();
        for (int i = 0; i < n; ++i) {
            Tag tag = Tag.newTag(this.type);
            tag.load(dataInput);
            this.list.add(tag);
        }
    }

    @Override
    public byte getId() {
        return 9;
    }

    @Override
    public String toString() {
        return "" + this.list.size() + " entries of type " + Tag.getTagName(this.type);
    }

    @Override
    public void print(String string, PrintStream printStream) {
        super.print(string, printStream);
        printStream.println(string + "{");
        String string2 = string;
        string = string + "   ";
        for (int i = 0; i < this.list.size(); ++i) {
            ((Tag)this.list.get(i)).print(string, printStream);
        }
        printStream.println(string2 + "}");
    }

    public void add(T t) {
        this.type = ((Tag)t).getId();
        this.list.add(t);
    }

    public T get(int n) {
        return (T)((Tag)this.list.get(n));
    }

    public int size() {
        return this.list.size();
    }
}

