/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt;

import com.mojang.nbt.ByteArrayTag;
import com.mojang.nbt.ByteTag;
import com.mojang.nbt.DoubleTag;
import com.mojang.nbt.FloatTag;
import com.mojang.nbt.IntTag;
import com.mojang.nbt.ListTag;
import com.mojang.nbt.LongTag;
import com.mojang.nbt.ShortTag;
import com.mojang.nbt.StringTag;
import com.mojang.nbt.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundTag
extends Tag {
    private Map<String, Tag> tags = new HashMap<String, Tag>();

    @Override
    void write(DataOutput dataOutput) throws IOException {
        for (Tag tag : this.tags.values()) {
            Tag.writeNamedTag(tag, dataOutput);
        }
        dataOutput.writeByte(0);
    }

    @Override
    void load(DataInput dataInput) throws IOException {
        Tag tag;
        this.tags.clear();
        while ((tag = Tag.readNamedTag(dataInput)).getId() != 0) {
            this.tags.put(tag.getName(), tag);
        }
    }

    @Override
    public byte getId() {
        return 10;
    }

    public void put(String string, Tag tag) {
        this.tags.put(string, tag.setName(string));
    }

    public void putByte(String string, byte by) {
        this.tags.put(string, new ByteTag(by).setName(string));
    }

    public void putShort(String string, short s) {
        this.tags.put(string, new ShortTag(s).setName(string));
    }

    public void putInt(String string, int n) {
        this.tags.put(string, new IntTag(n).setName(string));
    }

    public void putLong(String string, long l) {
        this.tags.put(string, new LongTag(l).setName(string));
    }

    public void putFloat(String string, float f) {
        this.tags.put(string, new FloatTag(f).setName(string));
    }

    public void putDouble(String string, double d) {
        this.tags.put(string, new DoubleTag(d).setName(string));
    }

    public void putString(String string, String string2) {
        this.tags.put(string, new StringTag(string2).setName(string));
    }

    public void putByteArray(String string, byte[] byArray) {
        this.tags.put(string, new ByteArrayTag(byArray).setName(string));
    }

    public void putCompound(String string, CompoundTag compoundTag) {
        this.tags.put(string, compoundTag.setName(string));
    }

    public void putBoolean(String string, boolean bl) {
        this.putByte(string, bl ? (byte)1 : 0);
    }

    public Tag get(String string) {
        return this.tags.get(string);
    }

    public boolean contains(String string) {
        return this.tags.containsKey(string);
    }

    public byte getByte(String string) {
        if (!this.tags.containsKey(string)) {
            return 0;
        }
        return ((ByteTag)this.tags.get((Object)string)).data;
    }

    public short getShort(String string) {
        if (!this.tags.containsKey(string)) {
            return 0;
        }
        return ((ShortTag)this.tags.get((Object)string)).data;
    }

    public int getInt(String string) {
        if (!this.tags.containsKey(string)) {
            return 0;
        }
        return ((IntTag)this.tags.get((Object)string)).data;
    }

    public long getLong(String string) {
        if (!this.tags.containsKey(string)) {
            return 0L;
        }
        return ((LongTag)this.tags.get((Object)string)).data;
    }

    public float getFloat(String string) {
        if (!this.tags.containsKey(string)) {
            return 0.0f;
        }
        return ((FloatTag)this.tags.get((Object)string)).data;
    }

    public double getDouble(String string) {
        if (!this.tags.containsKey(string)) {
            return 0.0;
        }
        return ((DoubleTag)this.tags.get((Object)string)).data;
    }

    public String getString(String string) {
        if (!this.tags.containsKey(string)) {
            return "";
        }
        return ((StringTag)this.tags.get((Object)string)).data;
    }

    public byte[] getByteArray(String string) {
        if (!this.tags.containsKey(string)) {
            return new byte[0];
        }
        return ((ByteArrayTag)this.tags.get((Object)string)).data;
    }

    public CompoundTag getCompound(String string) {
        if (!this.tags.containsKey(string)) {
            return new CompoundTag();
        }
        return (CompoundTag)this.tags.get(string);
    }

    public ListTag<? extends Tag> getList(String string) {
        if (!this.tags.containsKey(string)) {
            return new ListTag();
        }
        return (ListTag)this.tags.get(string);
    }

    public boolean getBoolean(String string) {
        return this.getByte(string) != 0;
    }

    @Override
    public String toString() {
        return "" + this.tags.size() + " entries";
    }

    @Override
    public void print(String string, PrintStream printStream) {
        super.print(string, printStream);
        printStream.println(string + "{");
        String string2 = string;
        string = string + "   ";
        for (Tag tag : this.tags.values()) {
            tag.print(string, printStream);
        }
        printStream.println(string2 + "}");
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }
}

