/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import net.minecraft.world.level.Level;

public class WorldGenProfiler {
    private Level level;
    private File workDir = new File("leveldata");

    public void run() {
        if (!this.workDir.exists()) {
            this.workDir.mkdir();
        }
        String string = "Test";
        System.out.print("Deleting level..");
        long l = System.currentTimeMillis();
        Level.deleteLevel(this.workDir, string);
        long l2 = System.currentTimeMillis();
        System.out.println(" " + (l2 - l) + " ms");
        System.out.print("Creating level..");
        l = System.currentTimeMillis();
        this.selectLevel(string);
        l2 = System.currentTimeMillis();
        System.out.println(" " + (l2 - l) + " ms");
    }

    public void selectLevel(String string) {
        this.level = new Level(new File(this.workDir, "saves"), string);
        this.prepareLevel();
        while (this.level.getLightsToUpdate() > 0) {
            this.level.updateLights();
        }
    }

    private void prepareLevel() {
        int n = 128;
        int n2 = this.level.xSpawn;
        int n3 = this.level.zSpawn;
        for (int i = -n; i <= n; i += 16) {
            for (int j = -n; j <= n; j += 16) {
                this.level.getTile(n2 + i, 64, n3 + j);
            }
        }
    }

    public static void main(String[] stringArray) {
        new WorldGenProfiler().run();
    }
}

